/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import io.esastack.httpclient.core.Reusable;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;

public class SslOptions
implements Reusable<SslOptions>,
Serializable {
    private static final long serialVersionUID = 743144112670237615L;
    private static final String[] EMPTY_ARRAYS = new String[0];
    private final String[] ciphers;
    private final String[] enabledProtocols;
    private final File trustCertificates;
    private final boolean useInsecureTrustManager;
    private final long sessionTimeout;
    private final long sessionCacheSize;
    private final long handshakeTimeoutMillis;

    private SslOptions(String[] ciphers, String[] enabledProtocols, File trustCertificates, boolean useInsecureTrustManager, long sessionTimeout, long sessionCacheSize, long handshakeTimeoutMillis) {
        this.ciphers = ciphers == null ? EMPTY_ARRAYS : ciphers;
        this.enabledProtocols = enabledProtocols == null ? EMPTY_ARRAYS : enabledProtocols;
        this.sessionTimeout = sessionTimeout;
        this.sessionCacheSize = sessionCacheSize;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
        this.trustCertificates = trustCertificates;
        this.useInsecureTrustManager = useInsecureTrustManager;
    }

    @Override
    public SslOptions copy() {
        return new SslOptions(this.ciphers == null ? EMPTY_ARRAYS : Arrays.copyOf(this.ciphers, this.ciphers.length), this.enabledProtocols == null ? EMPTY_ARRAYS : Arrays.copyOf(this.enabledProtocols, this.enabledProtocols.length), this.trustCertificates, this.useInsecureTrustManager, this.sessionTimeout, this.sessionCacheSize, this.handshakeTimeoutMillis);
    }

    public static SslOptionsBuilder options() {
        return new SslOptionsBuilder();
    }

    public String[] ciphers() {
        return this.ciphers;
    }

    public String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    public long sessionTimeout() {
        return this.sessionTimeout;
    }

    public long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public File trustCertificates() {
        return this.trustCertificates;
    }

    public boolean useInsecureTrustManager() {
        return this.useInsecureTrustManager;
    }

    public static class SslOptionsBuilder {
        private static final boolean DEFAULT_USE_INSECURE_TRUST_MANAGER = SystemPropertyUtil.getBoolean((String)"io.esastack.httpclient.sslOptions.useInsecureTrustManager", (boolean)false);
        private String[] ciphers;
        private String[] enabledProtocols;
        private File trustCertificates;
        private long sessionTimeout;
        private long sessionCacheSize;
        private long handshakeTimeoutMillis;

        SslOptionsBuilder() {
        }

        public SslOptionsBuilder ciphers(String[] ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public SslOptionsBuilder enabledProtocols(String[] enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public SslOptionsBuilder sessionTimeout(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public SslOptionsBuilder sessionCacheSize(long sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public SslOptionsBuilder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            return this;
        }

        public SslOptionsBuilder trustCertificates(File trustCertificates) {
            this.trustCertificates = trustCertificates;
            return this;
        }

        public SslOptions build() {
            return new SslOptions(this.ciphers, this.enabledProtocols, this.trustCertificates, DEFAULT_USE_INSECURE_TRUST_MANAGER, this.sessionTimeout, this.sessionCacheSize, this.handshakeTimeoutMillis);
        }
    }
}

