/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import esa.commons.Checks;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.netty.HandleImpl;
import io.esastack.httpclient.core.netty.NettyResponse;
import io.esastack.httpclient.core.util.LoggerUtils;
import java.util.function.Consumer;

public class ExecContext {
    private final Context ctx;
    private final Listener listener;
    private final Consumer<Handle> handle;
    private final Handler handler;
    private volatile Runnable continueCallback;

    public ExecContext(Context ctx, Listener listener, Consumer<Handle> handle, Handler handler) {
        Checks.checkNotNull((Object)ctx, (String)"ctx");
        Checks.checkNotNull((Object)listener, (String)"listener");
        this.ctx = ctx;
        this.listener = listener;
        this.handle = handle;
        this.handler = handler;
    }

    public Context ctx() {
        return this.ctx;
    }

    public Listener listener() {
        return this.listener;
    }

    public void set100ContinueCallback(Runnable callback) {
        this.continueCallback = callback;
    }

    public Runnable remove100ContinueCallback() {
        Runnable callback0 = this.continueCallback;
        this.continueCallback = null;
        return callback0;
    }

    public HandleImpl handleImpl(HttpRequest request) {
        if (this.handler != null && this.handle != null) {
            LoggerUtils.logger().warn("Both handler and consumer<handle> are found to handle theinbound message, the handler will be used, uri: {}", (Object)request.uri());
        }
        if (this.handler != null) {
            return new HandleImpl(new NettyResponse(false), this.handler);
        }
        if (this.handle != null) {
            return new HandleImpl(new NettyResponse(false), this.handle);
        }
        LoggerUtils.logger().debug("The default handle will be used to aggregate the inbound message to a response");
        return null;
    }
}

