/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.concurrent.CompletableFuture;

public class ExpectContinueInterceptor
implements Interceptor {
    @Override
    public CompletableFuture<HttpResponse> proceed(HttpRequest request, ExecChain next) {
        if (!Boolean.TRUE.equals(next.ctx().isUseExpectContinue())) {
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("100-Continue is disabled, uri: {}", (Object)request.uri().toString());
            }
            return next.proceed(request);
        }
        if (request.isSegmented()) {
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("100-Continue is unsupported for segment request, uri: {}", (Object)request.uri().toString());
            }
            request.headers().remove("expect");
            return next.proceed(request);
        }
        if (this.emptyBody(request)) {
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("100-Continue is ignored due to empty body, uri: {}", (Object)request.uri().toString());
            }
            request.headers().remove("expect");
            return next.proceed(request);
        }
        if (!request.headers().contains("expect")) {
            request.addHeader("expect", (CharSequence)HttpHeaderValues.CONTINUE);
        }
        return next.proceed(request);
    }

    @Override
    public int getOrder() {
        return -5000;
    }

    protected boolean emptyBody(HttpRequest request) {
        if (request.isSegmented()) {
            return true;
        }
        if (request.isMultipart()) {
            return request.files().isEmpty() && request.attrs().isEmpty();
        }
        return request.file() == null && (request.buffer() == null || request.buffer().readableBytes() <= 0);
    }
}

