/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import io.esastack.httpclient.core.ContextKeys;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.exec.RequestExecutorImpl;
import io.esastack.httpclient.core.filter.FilterContext;
import io.esastack.httpclient.core.filter.RequestFilter;
import io.esastack.httpclient.core.util.Futures;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class FilteringExec
implements Interceptor {
    private final RequestFilter[] requestFilters;
    private final boolean requestFiltersAbsent;

    public FilteringExec(RequestFilter[] requestFilters) {
        this.requestFilters = requestFilters;
        this.requestFiltersAbsent = requestFilters == null || requestFilters.length == 0;
    }

    @Override
    public CompletableFuture<HttpResponse> proceed(HttpRequest request, ExecChain next) {
        FilterContext ctx0 = new FilterContext(next.ctx());
        next.ctx().attrs().attr(ContextKeys.FILTER_CONTEXT_KEY).set((Object)ctx0);
        Listener listener = (Listener)next.ctx().attrs().attr(RequestExecutorImpl.LISTENER_KEY).getAndRemove();
        if (listener != null) {
            listener.onInterceptorsEnd(request, next.ctx());
            listener.onFiltersStart(request, ctx0);
        }
        return this.applyRequestFilters(request, ctx0).thenCompose(v -> next.proceed(request));
    }

    private CompletableFuture<Void> applyRequestFilters(HttpRequest request, FilterContext ctx) {
        if (this.requestFiltersAbsent) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> future = null;
        for (RequestFilter filter : this.requestFilters) {
            future = future == null ? filter.doFilter(request, ctx) : future.thenCompose(value -> filter.doFilter(request, ctx));
        }
        return future == null ? Futures.completed() : future;
    }
}

