/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import esa.commons.Checks;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.exec.HttpTransceiver;
import io.esastack.httpclient.core.exec.Interceptor;
import java.util.concurrent.CompletableFuture;

public class LinkedExecChain
implements ExecChain {
    private final Interceptor current;
    private final ExecChain next;
    private final Context ctx;

    private LinkedExecChain(Interceptor current, ExecChain next, Context ctx) {
        Checks.checkNotNull((Object)ctx, (String)"ctx");
        Checks.checkNotNull((Object)next, (String)"next");
        Checks.checkNotNull((Object)current, (String)"current");
        this.ctx = ctx;
        this.current = current;
        this.next = next;
    }

    @Override
    public Context ctx() {
        return this.ctx;
    }

    @Override
    public CompletableFuture<HttpResponse> proceed(HttpRequest request) {
        return this.current.proceed(request, this.next);
    }

    static ExecChain from(Interceptor[] interceptors, HttpTransceiver transceiver, ExecContext execContext) {
        if (interceptors.length == 0) {
            return LinkedExecChain.buildTransceiver(transceiver, execContext);
        }
        ExecChain chain = LinkedExecChain.buildTransceiver(transceiver, execContext);
        for (int i = interceptors.length - 1; i >= 0; --i) {
            chain = new LinkedExecChain(interceptors[i], chain, execContext.ctx());
        }
        return chain;
    }

    private static ExecChain buildTransceiver(final HttpTransceiver transceiver, final ExecContext execContext) {
        return new ExecChain(){

            @Override
            public Context ctx() {
                return execContext.ctx();
            }

            @Override
            public CompletableFuture<HttpResponse> proceed(HttpRequest request) {
                return transceiver.handle(request, execContext);
            }
        };
    }
}

