/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import esa.commons.StringUtils;
import esa.commons.collection.Attribute;
import esa.commons.collection.AttributeKey;
import esa.commons.collection.MultiValueMap;
import esa.commons.logging.Logger;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.commons.net.http.HttpStatus;
import io.esastack.httpclient.core.DelegatingRequest;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.HttpUri;
import io.esastack.httpclient.core.MultipartFileItem;
import io.esastack.httpclient.core.exception.RedirectException;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.util.LoggerUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RedirectInterceptor
implements Interceptor {
    static final AttributeKey<Integer> HAS_REDIRECTED_COUNT = AttributeKey.valueOf((String)"$redirected.count");
    private static final String SLASH = "/";
    private static final Logger logger = LoggerUtils.logger();

    @Override
    public CompletableFuture<HttpResponse> proceed(HttpRequest request, ExecChain next) {
        int maxRedirects = next.ctx().maxRedirects();
        if (request.isSegmented() || maxRedirects < 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Redirection is disabled, uri: {}, maxRedirects: {}", (Object)request.uri().toString(), (Object)maxRedirects);
            }
            return next.proceed(request);
        }
        CompletableFuture<HttpResponse> response = new CompletableFuture<HttpResponse>();
        this.doRedirect(response, request, next, maxRedirects);
        return response;
    }

    @Override
    public int getOrder() {
        return -3000;
    }

    protected void doRedirect(CompletableFuture<HttpResponse> response, HttpRequest request, ExecChain next, int maxRedirects) {
        if (response.isDone()) {
            return;
        }
        next.proceed(request).whenComplete((rsp, th) -> {
            try {
                Attribute countAttr = next.ctx().attrs().attr(HAS_REDIRECTED_COUNT);
                int hasDirectedCount = (Integer)countAttr.getOrDefault((Object)-1) + 1;
                countAttr.set((Object)hasDirectedCount);
                if (th != null) {
                    response.completeExceptionally((Throwable)th);
                    return;
                }
                boolean shouldRedirect = this.shouldRedirect((HttpResponse)rsp);
                if (!shouldRedirect) {
                    response.complete((HttpResponse)rsp);
                    return;
                }
                if (hasDirectedCount < maxRedirects) {
                    URI uri = this.detectURI(request, (HttpResponse)rsp);
                    HttpRequest request0 = this.newRequest(request, uri, rsp.status());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Begin to redirect from {} to {}, current redirectCount: {}", new Object[]{request, request0, hasDirectedCount + 1});
                    }
                    this.doRedirect(response, request0, next, maxRedirects);
                } else {
                    response.completeExceptionally(new RedirectException(String.format("Failed to proceed request after maxRedirects: %d", maxRedirects)));
                }
            }
            catch (Throwable ex) {
                response.completeExceptionally(new RedirectException("Unexpected exception occurred when redirecting", ex));
            }
        });
    }

    protected HttpRequest newRequest(HttpRequest request, URI uri, int status) {
        final HttpMethod method0 = this.switchToGet(request, status) ? HttpMethod.GET : request.method();
        final HttpUri uri0 = new HttpUri(uri, request.uri().unmodifiableParams());
        final boolean cleanBody = this.cleanBody(status);
        DelegatingRequest request0 = new DelegatingRequest((HttpRequest)request.copy()){

            @Override
            public HttpMethod method() {
                return method0;
            }

            @Override
            public String scheme() {
                return uri0.netURI().getScheme();
            }

            @Override
            public String path() {
                return uri0.path();
            }

            @Override
            public HttpUri uri() {
                return uri0;
            }

            @Override
            public boolean isSegmented() {
                return !cleanBody && super.isSegmented();
            }

            @Override
            public boolean isMultipart() {
                return !cleanBody && super.isMultipart();
            }

            @Override
            public Buffer buffer() {
                return cleanBody ? null : super.buffer();
            }

            @Override
            public File file() {
                return cleanBody ? null : super.file();
            }

            @Override
            public MultiValueMap<String, String> attrs() {
                return cleanBody ? null : super.attrs();
            }

            @Override
            public List<MultipartFileItem> files() {
                return cleanBody ? null : super.files();
            }

            @Override
            public String toString() {
                return uri0.toString();
            }
        };
        this.standardHeaders(request0.headers(), cleanBody);
        return request0;
    }

    protected boolean shouldRedirect(HttpResponse response) {
        if (!response.headers().contains("location")) {
            return false;
        }
        int status = response.status();
        return status == HttpStatus.MOVED_PERMANENTLY.code() || status == HttpStatus.FOUND.code() || status == HttpStatus.SEE_OTHER.code() || status == HttpStatus.TEMPORARY_REDIRECT.code() || status == HttpStatus.PERMANENT_REDIRECT.code();
    }

    protected boolean switchToGet(HttpRequest request, int status) {
        return status == HttpStatus.PERMANENT_REDIRECT.code() || status == HttpStatus.TEMPORARY_REDIRECT.code() || status == HttpStatus.SEE_OTHER.code();
    }

    protected boolean cleanBody(int status) {
        return status == HttpStatus.MOVED_PERMANENTLY.code() || status == HttpStatus.FOUND.code() || status == HttpStatus.SEE_OTHER.code();
    }

    protected URI detectURI(HttpRequest request, HttpResponse response) throws RedirectException {
        String location = response.headers().get("location");
        if (StringUtils.isEmpty((String)location)) {
            throw new RedirectException("Redirect location is missing");
        }
        if (location.startsWith(SLASH)) {
            try {
                URI uri0 = request.uri().netURI();
                RelativeInfo info = this.toRelativeInfo(location);
                return new URI(uri0.getScheme(), uri0.getRawAuthority(), info.path, info.query, info.fragment);
            }
            catch (URISyntaxException ex) {
                throw new RedirectException("Invalid redirect location: " + location, ex);
            }
        }
        return URI.create(location);
    }

    protected void standardHeaders(HttpHeaders headers, boolean cleanBody) {
        headers.remove("host").remove("content-length").remove("transfer-encoding").remove("content-type");
    }

    RelativeInfo toRelativeInfo(String uri) {
        int queryIndex = uri.indexOf("?");
        int fragmentIndex = uri.indexOf("#");
        int length = uri.length();
        RelativeInfo info = new RelativeInfo();
        if (queryIndex < 0 && fragmentIndex < 0) {
            info.path(uri);
            return info;
        }
        if (queryIndex > 0) {
            if (fragmentIndex < 0) {
                info.path(uri.substring(0, queryIndex));
                info.query(uri.substring(queryIndex + 1, length));
            } else {
                info.path(uri.substring(0, queryIndex));
                info.query(uri.substring(queryIndex + 1, fragmentIndex));
                info.fragment(uri.substring(fragmentIndex + 1, length));
            }
        } else if (fragmentIndex > 0) {
            info.path(uri.substring(0, fragmentIndex));
            info.fragment(uri.substring(fragmentIndex + 1, length));
        } else {
            info.path(uri);
        }
        return info;
    }

    static final class RelativeInfo {
        private String path;
        private String query;
        private String fragment;

        RelativeInfo() {
        }

        String path() {
            return this.path;
        }

        void path(String path) {
            this.path = path;
        }

        String query() {
            return this.query;
        }

        void query(String query) {
            this.query = query;
        }

        String fragment() {
            return this.fragment;
        }

        void fragment(String fragment) {
            this.fragment = fragment;
        }
    }
}

