/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import esa.commons.Checks;
import esa.commons.annotation.Internal;
import esa.commons.collection.AttributeKey;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.exec.HttpTransceiver;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.exec.LinkedExecChain;
import io.esastack.httpclient.core.exec.RequestExecutor;
import java.util.concurrent.CompletableFuture;

@Internal
public class RequestExecutorImpl
implements RequestExecutor {
    static final AttributeKey<Listener> LISTENER_KEY = AttributeKey.valueOf((String)"$listener");
    private final Interceptor[] interceptors;
    private final HttpTransceiver transceiver;

    public RequestExecutorImpl(Interceptor[] interceptors, HttpTransceiver transceiver) {
        Checks.checkNotNull((Object)interceptors, (String)"interceptors");
        Checks.checkNotNull((Object)transceiver, (String)"transceiver");
        this.transceiver = transceiver;
        this.interceptors = interceptors;
    }

    @Override
    public CompletableFuture<HttpResponse> execute(HttpRequest request, ExecContext execContext) {
        ExecChain chain = LinkedExecChain.from(this.interceptors, this.transceiver, execContext);
        execContext.listener().onInterceptorsStart(request, chain.ctx());
        chain.ctx().attrs().attr(LISTENER_KEY).set((Object)execContext.listener());
        return chain.proceed(request);
    }
}

