/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import esa.commons.Checks;
import esa.commons.collection.Attribute;
import esa.commons.collection.AttributeKey;
import esa.commons.logging.Logger;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exception.RetryException;
import io.esastack.httpclient.core.exec.ExecChain;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.exec.RetryPredicate;
import io.esastack.httpclient.core.util.Futures;
import io.esastack.httpclient.core.util.LoggerUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntToLongFunction;

public class RetryInterceptor
implements Interceptor {
    static final AttributeKey<Integer> HAS_RETRIED_COUNT = AttributeKey.valueOf((String)"$retried.count");
    private static final Logger logger = LoggerUtils.logger();
    private final RetryPredicate predicate;
    private final IntToLongFunction intervalMs;

    public RetryInterceptor(RetryPredicate predicate, IntToLongFunction intervalMs) {
        Checks.checkNotNull((Object)predicate, (String)"predicate");
        this.predicate = predicate;
        this.intervalMs = intervalMs;
    }

    @Override
    public CompletableFuture<HttpResponse> proceed(HttpRequest request, ExecChain next) {
        int maxRetries = next.ctx().maxRetries();
        if (maxRetries < 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retry is disabled, uri: {}, maxRetries: {}", (Object)request.uri().toString(), (Object)maxRetries);
            }
            return next.proceed(request);
        }
        if (request.isSegmented()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retry is unsupported for segment request, uri: {}, maxRetries: {}", (Object)request.uri().toString(), (Object)maxRetries);
            }
            return next.proceed(request);
        }
        CompletableFuture<HttpResponse> response = new CompletableFuture<HttpResponse>();
        this.doRetry(response, request, next, maxRetries);
        return response;
    }

    @Override
    public int getOrder() {
        return -4000;
    }

    protected void doRetry(CompletableFuture<HttpResponse> response, HttpRequest request, ExecChain next, int maxRetries) {
        if (response.isDone()) {
            return;
        }
        next.proceed(request).whenComplete((rsp, th) -> {
            block12: {
                try {
                    Attribute countAttr = next.ctx().attrs().attr(HAS_RETRIED_COUNT);
                    int hasRetriedCount = (Integer)countAttr.getOrDefault((Object)-1) + 1;
                    countAttr.set((Object)hasRetriedCount);
                    boolean canRetry = this.predicate.canRetry(request, (HttpResponse)rsp, next.ctx(), (Throwable)th);
                    if (!canRetry) {
                        if (rsp != null) {
                            response.complete((HttpResponse)rsp);
                        } else {
                            response.completeExceptionally(Futures.unwrapped(th));
                        }
                        return;
                    }
                    if (hasRetriedCount < maxRetries) {
                        if (this.intervalMs != null) {
                            try {
                                this.backOff(request, hasRetriedCount + 1, this.intervalMs);
                            }
                            catch (InterruptedException ex) {
                                response.completeExceptionally(new RetryException("Interrupted during retry interval", ex));
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Begin to retry request: {}, current retryCount: {}", (Object)request, (Object)(hasRetriedCount + 1));
                        }
                        this.doRetry(response, request, next, maxRetries);
                        break block12;
                    }
                    String msg = String.format("Failed to proceed request: " + request.uri().netURI().toString() + " after maxRetries: %d", maxRetries);
                    if (th == null) {
                        response.completeExceptionally(new RetryException(msg));
                    } else {
                        response.completeExceptionally(new RetryException(msg, (Throwable)th));
                    }
                }
                catch (Throwable ex) {
                    response.completeExceptionally(new RetryException("Unexpected exception occurred when retrying", ex));
                }
            }
        });
    }

    protected void backOff(HttpRequest request, int retryCount, IntToLongFunction intervalMs) throws InterruptedException {
        long interval = intervalMs.applyAsLong(retryCount);
        if (interval <= 0L) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Begin to back off before retrying request: {}, retryCount: {}", (Object)request, (Object)retryCount);
        }
        Thread.sleep(interval);
    }
}

