/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.exec;

import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exception.ClosedConnectionException;
import io.esastack.httpclient.core.exception.ClosedStreamException;
import io.esastack.httpclient.core.exec.RetryPredicate;
import io.esastack.httpclient.core.util.Futures;
import java.net.ConnectException;

public class RetryPredicateImpl
implements RetryPredicate {
    public static final RetryPredicateImpl DEFAULT = new RetryPredicateImpl();

    @Override
    public boolean canRetry(HttpRequest request, HttpResponse response, Context ctx, Throwable cause) {
        if (cause == null) {
            return false;
        }
        Throwable unwrapped = Futures.unwrapped(cause);
        if (unwrapped instanceof ConnectException || unwrapped instanceof ClosedConnectionException || unwrapped instanceof ClosedStreamException) {
            return true;
        }
        return this.canRetry0(request, response, ctx, cause);
    }

    protected boolean canRetry0(HttpRequest request, HttpResponse response, Context ctx, Throwable cause) {
        return false;
    }
}

