/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.reflect.BeanUtils;
import io.esastack.httpclient.cache.shaded.com.github.benmanes.caffeine.cache.Cache;
import io.esastack.httpclient.cache.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import io.esastack.httpclient.cache.shaded.com.github.benmanes.caffeine.cache.RemovalCause;
import io.esastack.httpclient.cache.shaded.com.github.benmanes.caffeine.cache.RemovalListener;
import io.esastack.httpclient.core.config.CacheOptions;
import io.esastack.httpclient.core.config.ChannelPoolOptions;
import io.esastack.httpclient.core.metrics.ConnectionPoolMetric;
import io.esastack.httpclient.core.metrics.ConnectionPoolMetricProvider;
import io.esastack.httpclient.core.netty.ChannelPool;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class CachedChannelPools
implements ConnectionPoolMetricProvider {
    private final Cache<SocketAddress, ChannelPool> cachedPools;
    private final AtomicBoolean closed = new AtomicBoolean();

    public CachedChannelPools(CacheOptions options) {
        Checks.checkNotNull((Object)options, (String)"options");
        this.cachedPools = Caffeine.newBuilder().initialCapacity(options.initialCapacity()).maximumSize(options.maximumSize()).expireAfterAccess(options.expireSeconds(), TimeUnit.SECONDS).removalListener(new ChannelPoolRemovalListener()).build();
        Utils.CLOSE_CONNECTION_POOL_SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                this.cachedPools.cleanUp();
                LoggerUtils.logger().debug("Scheduled cachedPools#cleanUp successfully.");
            }
            catch (Throwable th) {
                LoggerUtils.logger().error("Failed to schedule cachedPools#cleanUp.", th);
            }
        }, options.expireSeconds() / 2L, options.expireSeconds(), TimeUnit.SECONDS);
    }

    ChannelPool getIfPresent(SocketAddress address) {
        this.checkClosed();
        return this.cachedPools.getIfPresent(address);
    }

    ChannelPool getOrCreate(boolean keepAlive, SocketAddress address, Function<SocketAddress, ChannelPool> creator) {
        this.checkClosed();
        if (keepAlive) {
            return this.cachedPools.get(address, creator);
        }
        return creator.apply(address);
    }

    void put(SocketAddress address, ChannelPool channelPool) {
        this.checkClosed();
        if (channelPool != null) {
            this.cachedPools.put(address, channelPool);
        }
    }

    void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        for (Map.Entry entry : this.cachedPools.asMap().entrySet()) {
            try {
                CachedChannelPools.close((SocketAddress)entry.getKey(), (ChannelPool)entry.getValue(), false);
            }
            catch (Throwable th) {
                LoggerUtils.logger().error("Exception occurred when closing connection pool: {}", entry.getKey(), (Object)th);
            }
        }
    }

    @Override
    public ConnectionPoolMetric get(SocketAddress address) {
        if (this.closed.get()) {
            return null;
        }
        return this.all().get(address);
    }

    @Override
    public Map<SocketAddress, ConnectionPoolMetric> all() {
        if (this.closed.get()) {
            return Collections.emptyMap();
        }
        HashMap<SocketAddress, ChannelPool> channelPools0 = new HashMap<SocketAddress, ChannelPool>(this.cachedPools.asMap());
        HashMap<SocketAddress, ConnectionPoolMetric> metrics = new HashMap<SocketAddress, ConnectionPoolMetric>(channelPools0.size());
        for (Map.Entry entry : channelPools0.entrySet()) {
            metrics.put((SocketAddress)entry.getKey(), new ChannelPoolMetricImpl((ChannelPool)entry.getValue()));
        }
        return metrics;
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("ConnectionPools has been closed");
        }
    }

    static void close(SocketAddress address, ChannelPool channelPool, boolean async) {
        if (channelPool == null) {
            return;
        }
        io.netty.channel.pool.ChannelPool underlying = channelPool.underlying;
        if (!(underlying instanceof SimpleChannelPool)) {
            underlying.close();
            return;
        }
        long startTime = System.nanoTime();
        if (!async) {
            try {
                underlying.close();
                LoggerUtils.logger().info("Closed connection pool {} successfully, time elapsed: {}ms", (Object)address, (Object)((System.nanoTime() - startTime) / 1000000L));
            }
            catch (Throwable ex) {
                LoggerUtils.logger().error("Failed to close connection pool {}, time elapsed: {}ms", (Object)address, (Object)((System.nanoTime() - startTime) / 1000000L));
            }
        } else {
            Future closeFuture = ((SimpleChannelPool)underlying).closeAsync();
            if (closeFuture.isDone()) {
                CachedChannelPools.closingLog(address, (Future<Void>)closeFuture, startTime);
            } else {
                closeFuture.addListener(future -> CachedChannelPools.closingLog(address, (Future<Void>)closeFuture, startTime));
            }
        }
    }

    private static void closingLog(SocketAddress address, Future<Void> closeFuture, long startTime) {
        long endTime = System.nanoTime();
        if (closeFuture.isSuccess()) {
            LoggerUtils.logger().info("Closed connection pool {} successfully, time elapsed: {}ms", (Object)address, (Object)((endTime - startTime) / 1000000L));
        } else {
            LoggerUtils.logger().error("Failed to close connection pool {}, time elapsed: {}ms", (Object)address, (Object)((endTime - startTime) / 1000000L));
        }
    }

    private static class ChannelPoolMetricImpl
    implements ConnectionPoolMetric {
        private final FixedChannelPool channelPool;
        private final ChannelPoolOptions options;

        private ChannelPoolMetricImpl(ChannelPool channelPool) {
            this.channelPool = (FixedChannelPool)channelPool.underlying;
            this.options = channelPool.options;
        }

        @Override
        public int maxSize() {
            return (Integer)BeanUtils.getFieldValue((Object)this.channelPool, (String)"maxConnections");
        }

        @Override
        public int maxPendingAcquires() {
            return (Integer)BeanUtils.getFieldValue((Object)this.channelPool, (String)"maxPendingAcquires");
        }

        @Override
        public int active() {
            return ((AtomicInteger)BeanUtils.getFieldValue((Object)this.channelPool, (String)"acquiredChannelCount")).intValue();
        }

        @Override
        public int pendingAcquireCount() {
            return (Integer)BeanUtils.getFieldValue((Object)this.channelPool, (String)"pendingAcquireCount");
        }

        @Override
        public ChannelPoolOptions options() {
            return this.options;
        }

        public String toString() {
            return new StringJoiner(", ", ChannelPoolMetricImpl.class.getSimpleName() + "[", "]").add("options=" + this.options).add("maxSize=" + this.maxSize()).add("maxPendingAcquires=" + this.maxPendingAcquires()).add("active=" + this.active()).add("pendingAcquireCount=" + this.pendingAcquireCount()).toString();
        }
    }

    private static class ChannelPoolRemovalListener
    implements RemovalListener<SocketAddress, ChannelPool> {
        private ChannelPoolRemovalListener() {
        }

        @Override
        public void onRemoval(SocketAddress key, ChannelPool value, RemovalCause cause) {
            CachedChannelPools.close(key, value, true);
        }
    }
}

