/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.config.Http1Options;
import io.esastack.httpclient.core.config.Http2Options;
import io.esastack.httpclient.core.netty.ChannelPoolFactory;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.Http1ChannelHandler;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.Http2ConnectionHandlerBuilder;
import io.esastack.httpclient.core.netty.Http2FrameHandler;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.ConnectException;
import java.util.function.Supplier;

final class ChannelInitializer {
    private static final String INTERNAL_DEBUG_ENABLED_KEY = "io.esastack.httpclient.internalDebugEnabled";
    private static final boolean INTERNAL_DEBUG_ENABLED = SystemPropertyUtil.getBoolean((String)"io.esastack.httpclient.internalDebugEnabled", (boolean)false);
    private final boolean ssl;
    private final Supplier<SslHandler> sslHandler;
    private final HttpClientBuilder builder;

    ChannelInitializer(boolean ssl, Supplier<SslHandler> sslHandler, HttpClientBuilder builder) {
        Checks.checkNotNull((Object)builder, (String)"builder");
        this.ssl = ssl;
        this.sslHandler = sslHandler;
        this.builder = builder;
    }

    ChannelFuture onConnected(ChannelFuture connectFuture) {
        if (connectFuture.isDone() && !connectFuture.isSuccess()) {
            return connectFuture;
        }
        Channel channel = connectFuture.channel();
        ChannelPromise initializeFuture = channel.newPromise();
        if (connectFuture.isDone()) {
            if (connectFuture.isSuccess()) {
                this.doInitialize(channel, initializeFuture);
                return initializeFuture;
            }
            return connectFuture;
        }
        connectFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.doInitialize(channel, initializeFuture);
            } else {
                initializeFuture.setFailure(future.cause());
            }
        });
        return initializeFuture;
    }

    private void doInitialize(Channel channel, ChannelPromise initializeFuture) {
        this.applyOptions(channel);
        ChannelPoolFactory.NETTY_CONFIGURE.onChannelCreated(channel);
        this.addHandlers(channel, this.builder.version(), this.builder.http1Options(), this.builder.http2Options(), this.ssl, this.builder.isH2ClearTextUpgrade(), this.builder.isUseDecompress(), initializeFuture);
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("Connection: " + channel + " has connected successfully.");
            channel.closeFuture().addListener(f -> LoggerUtils.logger().debug("Connection: " + channel + " has closed."));
        }
    }

    private void applyOptions(Channel channel) {
        int low;
        int high = this.builder.netOptions() == null ? -1 : this.builder.netOptions().writeBufferHighWaterMark();
        int n = low = this.builder.netOptions() == null ? -1 : this.builder.netOptions().writeBufferLowWaterMark();
        if (high > 0) {
            if (low > 0) {
                channel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(low, high));
            } else {
                channel.config().setWriteBufferHighWaterMark(high);
            }
        } else if (low > 0) {
            channel.config().setWriteBufferLowWaterMark(low);
        }
    }

    private void addHandlers(final Channel channel, final io.esastack.commons.net.http.HttpVersion version, final Http1Options http1Options, final Http2Options http2Options, boolean ssl, boolean h2ClearTextUpgrade, final boolean decompression, final ChannelPromise initializeFuture) {
        ChannelPipeline pipeline = channel.pipeline();
        if (INTERNAL_DEBUG_ENABLED) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
        }
        if (this.builder.idleTimeoutSeconds() > 0) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, this.builder.idleTimeoutSeconds())});
        }
        if (ssl) {
            if (this.sslHandler == null) {
                throw new IllegalStateException("SslHandler is absent");
            }
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.sslHandler.get()});
            pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1"){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if (io.esastack.commons.net.http.HttpVersion.HTTP_2 == version && "h2".equals(protocol)) {
                        if (LoggerUtils.logger().isDebugEnabled()) {
                            LoggerUtils.logger().debug("Negotiated to use http2 successfully, connection: {}", (Object)channel);
                        }
                        ChannelInitializer.this.addH2Handlers(ctx.pipeline(), http2Options, decompression);
                        initializeFuture.setSuccess();
                    } else if (io.esastack.commons.net.http.HttpVersion.HTTP_2 != version && "http/1.1".equals(protocol)) {
                        if (LoggerUtils.logger().isDebugEnabled()) {
                            LoggerUtils.logger().debug("Negotiated to use http1.1 successfully, connection: {}", (Object)channel);
                        }
                        ChannelInitializer.this.addH1Handlers(ctx.pipeline(), http1Options, decompression);
                        initializeFuture.setSuccess();
                    } else {
                        IllegalStateException ex = new IllegalStateException("Unexpected negotiated protocol: " + protocol + ", configured: " + version);
                        initializeFuture.setFailure((Throwable)ex);
                        ctx.close();
                        throw ex;
                    }
                }

                protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    initializeFuture.setFailure((Throwable)new ConnectException("Failed to handshake"));
                    super.handshakeFailure(ctx, cause);
                }
            }});
        } else if (io.esastack.commons.net.http.HttpVersion.HTTP_2 == version) {
            if (h2ClearTextUpgrade) {
                this.addH2cHandlers(pipeline, http1Options, http2Options, decompression, initializeFuture);
            } else {
                this.addH2Handlers(pipeline, http2Options, decompression);
                initializeFuture.setSuccess();
            }
        } else {
            this.addH1Handlers(pipeline, http1Options, decompression);
            initializeFuture.setSuccess();
        }
    }

    private void addH1Handlers(ChannelPipeline pipeline, Http1Options http1Options, boolean decompression) {
        HttpClientCodec codec = http1Options == null ? new HttpClientCodec() : new HttpClientCodec(http1Options.maxInitialLineLength(), http1Options.maxHeaderSize(), http1Options.maxChunkSize());
        pipeline.addLast(new ChannelHandler[]{codec});
        if (decompression) {
            pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor(false)});
        }
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        HandleRegistry registry = new HandleRegistry(1, 0);
        pipeline.addLast(new ChannelHandler[]{new Http1ChannelHandler(registry, this.builder.maxContentLength())});
    }

    private void addH2Handlers(ChannelPipeline pipeline, Http2Options http2Options, boolean decompression) {
        HandleRegistry registry = new HandleRegistry(2, 1);
        Http2ConnectionHandler h2Handler = this.buildH2Handler(registry, http2Options, decompression);
        pipeline.addLast(new ChannelHandler[]{h2Handler});
    }

    private void addH2cHandlers(ChannelPipeline pipeline, final Http1Options http1Options, Http2Options http2Options, final boolean decompression, final ChannelPromise initializeFuture) {
        HandleRegistry registry = new HandleRegistry(2, 1);
        Http2ConnectionHandler h2Handler = this.buildH2Handler(registry, http2Options, decompression);
        HttpClientCodec codec = new HttpClientCodec();
        HttpClientUpgradeHandler upgrade = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)codec, (HttpClientUpgradeHandler.UpgradeCodec)new UpgradeCodecImpl(h2Handler, h2Handler, initializeFuture), 65536);
        pipeline.addLast("codec", (ChannelHandler)codec);
        pipeline.addLast("upgrade", (ChannelHandler)upgrade);
        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)ChannelInitializer.buildH2cRequest());
                ctx.fireChannelActive();
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }});
        pipeline.addLast("fallbackToH1", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED == evt) {
                    ctx.pipeline().remove("codec");
                    ctx.pipeline().remove((ChannelHandler)this);
                    ChannelInitializer.this.addH1Handlers(ctx.pipeline(), http1Options, decompression);
                    initializeFuture.setSuccess();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                initializeFuture.setFailure(cause);
            }
        });
    }

    private Http2ConnectionHandler buildH2Handler(HandleRegistry registry, Http2Options http2Options, boolean decompression) {
        DefaultHttp2Connection connection = http2Options == null ? new DefaultHttp2Connection(false) : new DefaultHttp2Connection(false, http2Options.maxReservedStreams());
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader();
        if (http2Options != null) {
            try {
                writer.maxFrameSize(http2Options.maxFrameSize());
                reader.maxFrameSize(http2Options.maxFrameSize());
            }
            catch (Http2Exception ex) {
                throw ExceptionUtils.asRuntime((Throwable)ex);
            }
        }
        if (INTERNAL_DEBUG_ENABLED) {
            Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG);
            reader = new Http2InboundFrameLogger((Http2FrameReader)reader, frameLogger);
            writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, frameLogger);
        }
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, (Http2FrameWriter)writer);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        Http2ConnectionHandlerBuilder builder = new Http2ConnectionHandlerBuilder(registry).codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
        builder.frameListener((Http2FrameListener)(decompression ? new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new Http2FrameHandler(registry, (Http2Connection)connection, this.builder.maxContentLength())) : new Http2FrameHandler(registry, (Http2Connection)connection, this.builder.maxContentLength())));
        if (http2Options != null) {
            builder.gracefulShutdownTimeoutMillis(http2Options.gracefulShutdownTimeoutMillis());
        }
        return builder.build();
    }

    private static DefaultHttpRequest buildH2cRequest() {
        return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
    }

    private static final class UpgradeCodecImpl
    extends Http2ClientUpgradeCodec
    implements HttpClientUpgradeHandler.UpgradeCodec {
        private final Http2ConnectionHandler h2Handler;
        private final ChannelPromise initializeFuture;

        private UpgradeCodecImpl(io.netty.handler.codec.http2.Http2ConnectionHandler connectionHandler, Http2ConnectionHandler h2Handler, ChannelPromise initializeFuture) {
            super(connectionHandler);
            this.h2Handler = h2Handler;
            this.initializeFuture = initializeFuture;
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) {
            try {
                ctx.pipeline().remove("fallbackToH1");
                ctx.pipeline().addLast(new ChannelHandler[]{this.h2Handler});
                this.h2Handler.onHttpClientUpgrade();
                this.initializeFuture.setSuccess();
            }
            catch (Http2Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
                ctx.close();
            }
        }
    }
}

