/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.Scheme;
import io.esastack.httpclient.core.config.ChannelPoolOptions;
import io.esastack.httpclient.core.config.NetOptions;
import io.esastack.httpclient.core.config.SslOptions;
import io.esastack.httpclient.core.netty.ChannelInitializer;
import io.esastack.httpclient.core.netty.ChannelPool;
import io.esastack.httpclient.core.netty.NettyClientConfigure;
import io.esastack.httpclient.core.netty.NettyClientConfigureImpl;
import io.esastack.httpclient.core.netty.ResolverGroupImpl;
import io.esastack.httpclient.core.resolver.HostResolver;
import io.esastack.httpclient.core.spi.SslEngineFactory;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;

final class ChannelPoolFactory {
    static final NettyClientConfigure NETTY_CONFIGURE = new NettyClientConfigureImpl();
    private static final String PREFER_UNPOOLED_KEY = "io.esastack.httpclient.preferUnpooled";
    private static final boolean PREFER_UNPOOLED = SystemPropertyUtil.getBoolean((String)"io.esastack.httpclient.preferUnpooled", (boolean)false);
    private static final String PREFER_NATIVE_KEY = "io.esastack.httpclient.preferNative";
    static final boolean PREFER_NATIVE = SystemPropertyUtil.getBoolean((String)"io.esastack.httpclient.preferNative", (boolean)true);
    final SslEngineFactory sslEngineFactory;

    ChannelPoolFactory(SslEngineFactory sslEngineFactory) {
        Checks.checkNotNull((Object)sslEngineFactory, (String)"sslEngineFactory");
        this.sslEngineFactory = sslEngineFactory;
    }

    ChannelPool create(boolean ssl, boolean keepAlive, SocketAddress address, EventLoopGroup ioThreads, ChannelPoolOptions options, HttpClientBuilder builder) {
        Object underlying;
        Bootstrap bootstrap = ChannelPoolFactory.buildBootstrap(address, ioThreads, builder.netOptions(), options.connectTimeout(), builder.resolver());
        NETTY_CONFIGURE.onBootstrapCreated(address, bootstrap);
        AbstractChannelPoolHandler handler = new AbstractChannelPoolHandler(){

            public void channelReleased(Channel ch) {
                ch.flush();
            }

            public void channelCreated(Channel ch) {
            }
        };
        Supplier<SslHandler> sslHandler = null;
        if (ssl) {
            sslHandler = () -> this.buildSslHandler(options.connectTimeout(), address, builder.sslOptions());
        }
        ChannelInitializer initializer = new ChannelInitializer(ssl, sslHandler, builder);
        if (keepAlive) {
            LoggerUtils.logger().info("Begin to create a new connection pool, address: {}, options: {}", (Object)address, (Object)options);
            underlying = new ChannelPoolImpl(bootstrap, (ChannelPoolHandler)handler, initializer, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, options.connectTimeout(), options.poolSize(), options.waitingQueueLength());
        } else {
            LoggerUtils.logger().debug("Begin to create a new connection pool, address: {}, options: {}", (Object)address, (Object)options);
            underlying = new DirectConnectAndCloseChannelPool(bootstrap, (ChannelPoolHandler)handler, initializer);
        }
        return new ChannelPool(ssl, (io.netty.channel.pool.ChannelPool)underlying, options);
    }

    private SslHandler buildSslHandler(int connectTimeout, SocketAddress address, SslOptions sslOptions) {
        SSLEngine sslEngine = this.sslEngineFactory.create(sslOptions, ((InetSocketAddress)address).getHostName(), ((InetSocketAddress)address).getPort() > 0 ? ((InetSocketAddress)address).getPort() : Scheme.HTTPS.port());
        if (sslOptions != null && sslOptions.enabledProtocols().length > 0) {
            sslEngine.setEnabledProtocols(sslOptions.enabledProtocols());
        }
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (sslOptions != null && sslOptions.handshakeTimeoutMillis() > 0L) {
            sslHandler.setHandshakeTimeoutMillis(sslOptions.handshakeTimeoutMillis());
        } else if (connectTimeout > 0) {
            sslHandler.setHandshakeTimeoutMillis(Duration.ofSeconds(connectTimeout).toMillis());
        }
        return sslHandler;
    }

    static Bootstrap buildBootstrap(SocketAddress address, EventLoopGroup ioThreads, NetOptions netOptions, int connectTimeout, HostResolver resolver) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(ioThreads);
        if (PREFER_NATIVE && Epoll.isAvailable()) {
            bootstrap.channel(EpollSocketChannel.class);
        } else {
            bootstrap.channel(NioSocketChannel.class);
        }
        if (netOptions != null) {
            ChannelPoolFactory.applyNetOptions(bootstrap, netOptions);
        }
        if (PREFER_UNPOOLED) {
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        if (resolver != null) {
            bootstrap.resolver((AddressResolverGroup)ResolverGroupImpl.mappingTo(resolver));
        }
        bootstrap.remoteAddress(address);
        return bootstrap;
    }

    private static void applyNetOptions(Bootstrap bootstrap, NetOptions options) {
        if (options.isSoKeepAlive()) {
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        if (options.isTcpNoDelay()) {
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        }
        if (options.isSoReuseAddr()) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        }
        if (options.soRcvBuf() > 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.soRcvBuf());
        }
        if (options.soSndBuf() > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.soSndBuf());
        }
        if (options.soLinger() > 0) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)options.soLinger());
        }
    }

    private static final class DirectConnectAndCloseChannelPool
    extends SimpleChannelPool {
        private final ChannelInitializer initializer;

        private DirectConnectAndCloseChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelInitializer initializer) {
            super(bootstrap, handler, ChannelHealthChecker.ACTIVE, false, false);
            this.initializer = initializer;
        }

        protected Channel pollChannel() {
            return null;
        }

        protected boolean offerChannel(Channel channel) {
            channel.close();
            return true;
        }

        protected ChannelFuture connectChannel(Bootstrap bs) {
            return this.initializer.onConnected(super.connectChannel(bs));
        }
    }

    private static final class ChannelPoolImpl
    extends FixedChannelPool {
        private final ChannelInitializer initializer;

        private ChannelPoolImpl(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelInitializer initializer, ChannelHealthChecker healthCheck, FixedChannelPool.AcquireTimeoutAction action, long acquireTimeoutMillis, int maxConnections, int maxPendingAcquires) {
            super(bootstrap, handler, healthCheck, action, acquireTimeoutMillis, maxConnections, maxPendingAcquires);
            this.initializer = initializer;
        }

        protected ChannelFuture connectChannel(Bootstrap bs) {
            return this.initializer.onConnected(super.connectChannel(bs));
        }
    }
}

