/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.netty.buffer.BufferImpl;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.netty.HandleImpl;
import io.esastack.httpclient.core.netty.NettyResponse;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.BufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.util.function.Consumer;

class DefaultHandle
extends HandleImpl {
    private static final int MAX_COMPOSITE_BUFFER_COMPONENTS = 1024;
    private CompositeByteBuf body;

    DefaultHandle(ByteBufAllocator alloc) {
        super(new NettyResponse(true));
        this.data = d -> {
            if (d.readableBytes() > 0) {
                if (this.body == null) {
                    this.body = alloc.compositeBuffer(1024);
                }
                this.body.addComponent(true, BufferUtils.toByteBuf(d).retain());
            }
        };
        this.end = v -> {
            if (this.body == null) {
                this.underlying.body(Buffer.defaultAlloc().empty());
            } else {
                this.underlying.body((Buffer)new BufferImpl(Unpooled.copiedBuffer((ByteBuf)this.body)));
            }
            Utils.tryRelease((ReferenceCounted)this.body);
        };
        this.trailers = trailers -> this.trailers().add(trailers);
        this.error = th -> Utils.tryRelease((ReferenceCounted)this.body);
    }

    @Override
    public Handle onStart(Consumer<Void> h) {
        return this;
    }

    @Override
    public DefaultHandle onData(Consumer<Buffer> h) {
        return this;
    }

    @Override
    public DefaultHandle onTrailer(Consumer<HttpHeaders> h) {
        return this;
    }

    @Override
    public DefaultHandle onEnd(Consumer<Void> h) {
        return this;
    }

    @Override
    public DefaultHandle onError(Consumer<Throwable> h) {
        return this;
    }
}

