/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.httpclient.core.resolver.HostResolver;
import io.netty.resolver.InetNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.List;

class DelegatingResolver
extends InetNameResolver {
    private final HostResolver delegate;

    DelegatingResolver(EventExecutor executor, HostResolver delegate) {
        super(executor);
        Checks.checkNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise) {
        this.delegate.resolve(inetHost).whenComplete((address, th) -> {
            if (th != null) {
                promise.setFailure(th);
            } else {
                promise.setSuccess(address);
            }
        });
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) {
        throw new UnsupportedOperationException("Please use doResolve() instead of doResolveAll()");
    }
}

