/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.io.IOUtils;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.Http2ChunkedInput;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.RequestWriterImpl;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.HttpHeadersUtils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileWriter
extends RequestWriterImpl {
    private static final String MODE_READ = "r";
    private static final FileWriter INSTANCE = new FileWriter();

    @Override
    public ChannelFuture writeAndFlush(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, boolean useUriEncode, HttpVersion version, boolean http2) throws IOException {
        FileWriter.addContentTypeIfAbsent(request, () -> HttpHeaderValues.APPLICATION_OCTET_STREAM);
        FileWriter.addContentLengthIfAbsent(request, v -> request.file() == null ? 0L : request.file().length());
        return super.writeAndFlush(request, channel, execCtx, headFuture, useUriEncode, version, http2);
    }

    @Override
    ChannelFuture writeAndFlush1(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, HttpVersion version, boolean uriEncodeEnabled) {
        DefaultHttpRequest req = new DefaultHttpRequest(version, HttpMethod.valueOf((String)request.method().name()), request.uri().relative(uriEncodeEnabled), (HttpHeaders)((Http1HeadersImpl)request.headers()));
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("Send Request:\n" + req);
        }
        channel.write((Object)req, headFuture);
        ChannelPromise endPromise = channel.newPromise();
        if (FileWriter.writeContentNow(execCtx, request)) {
            FileWriter.doWriteContent1(request, channel, endPromise);
        } else {
            channel.flush();
            execCtx.set100ContinueCallback(() -> FileWriter.doWriteContent1(request, channel, endPromise));
        }
        return endPromise;
    }

    private static void doWriteContent1(HttpRequest request, Channel channel, ChannelPromise endPromise) {
        RandomAccessFile rFile = null;
        ChunkedFile chunked = null;
        try {
            rFile = new RandomAccessFile(request.file(), MODE_READ);
            long length = rFile.length();
            if (channel.pipeline().get(SslHandler.class) == null) {
                channel.write((Object)new DefaultFileRegion(rFile.getChannel(), 0L, length));
                channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, endPromise);
            } else {
                chunked = new ChunkedFile(rFile);
                channel.writeAndFlush((Object)chunked, endPromise);
            }
            FileWriter.cleanAndLog((ChannelFuture)endPromise, chunked);
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(rFile);
            endPromise.setFailure((Throwable)ex);
        }
    }

    @Override
    ChannelFuture writeAndFlush2(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, Http2ConnectionHandler handler, int streamId, boolean uriEncodeEnabled) {
        ChannelFuture future = this.checkAndWriteH2Headers(channel, handler, HttpHeadersUtils.toHttp2Headers(request, (Http1HeadersImpl)request.headers(), uriEncodeEnabled), streamId, false, headFuture);
        if (future.isDone() && !future.isSuccess()) {
            return future;
        }
        ChannelPromise endPromise = channel.newPromise();
        if (FileWriter.writeContentNow(execCtx, request)) {
            Utils.runInChannel(channel, () -> {
                try {
                    FileWriter.doWriteContent2(request.file(), channel, streamId, endPromise);
                }
                catch (IOException e) {
                    endPromise.setFailure((Throwable)e);
                }
            });
        } else {
            channel.flush();
            execCtx.set100ContinueCallback(() -> Utils.runInChannel(channel, () -> {
                try {
                    FileWriter.doWriteContent2(request.file(), channel, streamId, endPromise);
                }
                catch (IOException ex) {
                    endPromise.setFailure((Throwable)ex);
                }
            }));
        }
        return endPromise;
    }

    private static void doWriteContent2(File file, Channel channel, int streamId, ChannelPromise endPromise) throws IOException {
        ChunkedFile chunked = null;
        try {
            RandomAccessFile rFile = new RandomAccessFile(file, MODE_READ);
            chunked = new ChunkedFile(rFile);
            FileWriter.cleanAndLog(channel.writeAndFlush((Object)new Http2ChunkedInput((ChunkedInput<ByteBuf>)chunked, streamId), endPromise), chunked);
        }
        catch (Throwable th) {
            IOException ex = th instanceof IOException ? (IOException)th : new IOException(th);
            FileWriter.closeChunkedInputQuietly(chunked);
            throw ex;
        }
    }

    private static void cleanAndLog(ChannelFuture future, ChunkedInput<?> chunked) {
        if (future.isDone()) {
            FileWriter.closeChunkedInputQuietly(chunked);
        } else {
            future.addListener(f -> FileWriter.closeChunkedInputQuietly(chunked));
        }
    }

    private static void closeChunkedInputQuietly(ChunkedInput<?> chunkedInput) {
        if (chunkedInput != null) {
            try {
                chunkedInput.close();
            }
            catch (Exception ex) {
                LoggerUtils.logger().error("Error while closing chunked input", (Throwable)ex);
            }
        }
    }

    private FileWriter() {
    }

    static FileWriter singleton() {
        return INSTANCE;
    }
}

