/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.filter.FilterContext;
import io.esastack.httpclient.core.filter.ResponseFilter;
import io.esastack.httpclient.core.netty.HandleImpl;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import java.util.concurrent.CompletableFuture;

class FilteringHandle
extends ResponseHandle {
    private final ResponseFilter[] filters;
    private final FilterContext ctx;
    private CompletableFuture<Void> handleChain;

    FilteringHandle(HandleImpl handle, HttpRequest request, ExecContext execContext, TimeoutHandle tHandle, CompletableFuture<HttpResponse> response, ResponseFilter[] filters, FilterContext fCtx) {
        super(handle, request, execContext, tHandle, response);
        Checks.checkNotNull((Object)fCtx, (String)"fCtx");
        Checks.checkNotEmptyArg((Object[])filters, (String)"filters");
        this.filters = filters;
        this.ctx = fCtx;
    }

    @Override
    public void onMessage(HttpMessage message) {
        super.onMessage(message);
        try {
            for (ResponseFilter filter : this.filters) {
                this.handleChain = this.handleChain == null ? filter.doFilter(this.request, this.handle.underlying, this.ctx) : this.handleChain.thenCompose(v -> filter.doFilter(this.request, this.handle.underlying, this.ctx));
            }
        }
        catch (Throwable ex) {
            super.onError(ex);
        }
        if (this.handleChain == null) {
            return;
        }
        this.handleChain = this.handleChain.exceptionally(th -> {
            super.onError((Throwable)th);
            return null;
        });
    }

    @Override
    public void onData(Buffer content) {
        if (this.handleChain == null) {
            return;
        }
        this.handleChain = this.handleChain.whenComplete((v, th) -> {
            if (th != null) {
                super.onError((Throwable)th);
            } else {
                super.onData(content);
            }
        });
    }

    @Override
    public void onEnd() {
        if (this.handleChain == null) {
            return;
        }
        this.handleChain = this.handleChain.whenComplete((v, th) -> {
            if (th != null) {
                super.onError((Throwable)th);
            } else {
                super.onEnd();
            }
        });
        this.handleChain.exceptionally(th -> {
            super.onError((Throwable)th);
            return null;
        });
    }

    @Override
    public void onTrailers(HttpHeaders trailers) {
        if (this.handleChain == null) {
            return;
        }
        this.handleChain = this.handleChain.whenComplete((v, th) -> {
            if (th != null) {
                super.onError((Throwable)th);
            } else {
                super.onTrailers(trailers);
            }
        });
    }
}

