/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.Http1ChannelHandler;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.esastack.httpclient.core.netty.TransceiverHandle;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import java.util.concurrent.atomic.AtomicBoolean;

class H1TransceiverHandle
extends TransceiverHandle {
    H1TransceiverHandle() {
    }

    @Override
    public TimeoutHandle buildTimeoutHandle(Channel channel, ChannelPool channelPool, Listener delegate, HttpVersion version) {
        return new H1Listener(channelPool, delegate, channel, version);
    }

    @Override
    int addRspHandle0(HttpRequest request, Context ctx, Channel channel, ResponseHandle handle, HandleRegistry registry) {
        int requestId = registry.put(handle);
        ((Http1ChannelHandler)channel.pipeline().last()).updateRequestId(requestId);
        return requestId;
    }

    private static class H1Listener
    extends TimeoutHandle {
        private final AtomicBoolean released = new AtomicBoolean();
        private final ChannelPool channelPool;
        private final Channel channel;
        private final HttpVersion version;

        private H1Listener(ChannelPool channelPool, Listener delegate, Channel channel, HttpVersion version) {
            super(delegate);
            this.channelPool = channelPool;
            this.channel = channel;
            this.version = version;
        }

        @Override
        public void onCompleted(HttpRequest request, Context ctx, HttpResponse response) {
            if (H1Listener.closeNow(response, this.version)) {
                this.channel.close();
            }
            if (this.released.compareAndSet(false, true)) {
                this.channelPool.release(this.channel);
            }
            super.onCompleted(request, ctx, response);
        }

        @Override
        public void onError(HttpRequest request, Context ctx, Throwable cause) {
            if (this.released.compareAndSet(false, true)) {
                this.channelPool.release(this.channel);
            }
            super.onError(request, ctx, cause);
        }

        private static boolean closeNow(HttpResponse response, HttpVersion version) {
            if (response.headers().contains("connection", "close", true)) {
                return true;
            }
            return HttpVersion.HTTP_1_1 != version && !response.headers().contains("connection", "keep-alive", true);
        }
    }
}

