/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.esastack.httpclient.core.netty.TransceiverHandle;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.concurrent.atomic.AtomicBoolean;

class H2TransceiverHandle
extends TransceiverHandle {
    H2TransceiverHandle() {
    }

    @Override
    public TimeoutHandle buildTimeoutHandle(Channel channel, ChannelPool channelPool, Listener delegate, HttpVersion version) {
        return new H2Listener(delegate, channelPool, channel);
    }

    @Override
    int addRspHandle0(HttpRequest request, Context ctx, Channel channel, ResponseHandle handle, HandleRegistry registry) {
        int requestId = registry.put(handle);
        request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)String.valueOf(requestId));
        return requestId;
    }

    private static class H2Listener
    extends TimeoutHandle {
        private final AtomicBoolean released = new AtomicBoolean();
        private final ChannelPool channelPool;
        private final Channel channel;

        private H2Listener(Listener delegate, ChannelPool channelPool, Channel channel) {
            super(delegate);
            this.channelPool = channelPool;
            this.channel = channel;
        }

        @Override
        public void onWriteDone(HttpRequest request, Context ctx) {
            if (this.released.compareAndSet(false, true)) {
                this.channelPool.release(this.channel);
            }
            super.onWriteDone(request, ctx);
        }

        @Override
        public void onCompleted(HttpRequest request, Context ctx, HttpResponse response) {
            if (this.released.compareAndSet(false, true)) {
                this.channelPool.release(this.channel);
            }
            super.onCompleted(request, ctx, response);
        }

        @Override
        public void onError(HttpRequest request, Context ctx, Throwable cause) {
            if (this.released.compareAndSet(false, true)) {
                this.channelPool.release(this.channel);
            }
            super.onError(request, ctx, cause);
        }
    }
}

