/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.netty.NettyResponse;
import java.util.function.Consumer;

public class HandleImpl
implements Handle {
    final NettyResponse underlying;
    protected volatile Consumer<Buffer> data;
    protected volatile Consumer<HttpHeaders> trailers;
    protected volatile Consumer<Void> end;
    protected volatile Consumer<Throwable> error;
    volatile Consumer<Void> start;

    public HandleImpl(NettyResponse underlying) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
    }

    public HandleImpl(NettyResponse underlying, Handler handler) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        Checks.checkNotNull((Object)handler, (String)"handler");
        this.underlying = underlying;
        this.start = v -> handler.onStart();
        this.data = handler::onData;
        this.trailers = handler::onTrailers;
        this.end = v -> handler.onEnd();
        this.error = handler::onError;
    }

    public HandleImpl(NettyResponse underlying, Consumer<Handle> handle0) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        Checks.checkNotNull(handle0, (String)"handle0");
        this.underlying = underlying;
        handle0.accept(this);
    }

    @Override
    public Handle onStart(Consumer<Void> h) {
        this.start = h;
        return this;
    }

    @Override
    public Handle onData(Consumer<Buffer> h) {
        this.data = h;
        return this;
    }

    @Override
    public Handle onTrailer(Consumer<HttpHeaders> h) {
        this.trailers = h;
        return this;
    }

    @Override
    public Handle onEnd(Consumer<Void> h) {
        this.end = h;
        return this;
    }

    @Override
    public Handle onError(Consumer<Throwable> h) {
        this.error = h;
        return this;
    }

    @Override
    public Buffer body() {
        return this.underlying.body();
    }

    @Override
    public HttpHeaders trailers() {
        return this.underlying.trailers();
    }

    @Override
    public int status() {
        return this.underlying.status();
    }

    @Override
    public HttpVersion version() {
        return this.underlying.version();
    }

    @Override
    public HttpHeaders headers() {
        return this.underlying.headers();
    }

    @Override
    public boolean aggregated() {
        return this.underlying.aggregated();
    }
}

