/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.httpclient.core.netty.ResponseHandle;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.function.Consumer;

class HandleRegistry {
    private final IntObjectMap<ResponseHandle> handlers = new IntObjectHashMap(16);
    private final int delta;
    private int requestId;

    HandleRegistry(int delta, int requestId) {
        this.requestId = requestId;
        this.delta = delta;
    }

    public synchronized ResponseHandle remove(int requestId) {
        return (ResponseHandle)this.handlers.remove(requestId);
    }

    public synchronized int put(ResponseHandle handle) {
        this.requestId += this.delta;
        this.handlers.putIfAbsent((Object)this.requestId, (Object)handle);
        return this.requestId;
    }

    public synchronized ResponseHandle get(int requestId) {
        return (ResponseHandle)this.handlers.get(requestId);
    }

    synchronized void handleAndClearAll(Consumer<ResponseHandle> handle) {
        this.handlers.forEach((id, h) -> handle.accept((ResponseHandle)h));
        this.handlers.clear();
    }
}

