/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.netty.buffer.BufferImpl;
import io.esastack.commons.net.netty.http.Http1HeadersAdaptor;
import io.esastack.httpclient.core.exception.ClosedConnectionException;
import io.esastack.httpclient.core.exception.ContentOverSizedException;
import io.esastack.httpclient.core.exception.ProtocolException;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.HttpMessageImpl;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;

class Http1ChannelHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final HandleRegistry registry;
    private final long maxContentLength;
    private volatile ChannelHandlerContext ctx;
    private volatile Channel channel;
    private int reusableRequestId;
    private boolean continue100Received;
    private long remaining = -1L;

    Http1ChannelHandler(HandleRegistry registry, long maxContentLength) {
        Checks.checkNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.maxContentLength = maxContentLength;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.channel = ctx.channel();
        super.handlerAdded(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.onError(cause, true);
        }
        finally {
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.onError(new ClosedConnectionException("Connection: " + ctx.channel() + " inactive"), false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!Utils.handleIdleEvt(ctx, evt)) {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        ResponseHandle handle = this.registry.get(this.reusableRequestId);
        if (handle == null) {
            if (LoggerUtils.logger().isDebugEnabled()) {
                int size = msg instanceof HttpResponse ? 0 : ((HttpContent)msg).content().readableBytes();
                LoggerUtils.logger().debug("There is no handler to handle inbound object, size: {} connection: {}", (Object)size, (Object)ctx.channel());
            }
            return;
        }
        if (!msg.decoderResult().isSuccess()) {
            this.handleDecodeError(msg.decoderResult().cause());
            return;
        }
        if (msg instanceof HttpResponse) {
            this.handleResponse(handle, (HttpResponse)msg);
        } else if (msg instanceof HttpContent) {
            if (this.continue100Received) {
                if (msg instanceof LastHttpContent) {
                    this.continue100Received = false;
                }
                return;
            }
            if (LastHttpContent.EMPTY_LAST_CONTENT == msg) {
                handle.onEnd();
                this.registry.remove(this.reusableRequestId);
                return;
            }
            ByteBuf content = ((HttpContent)msg).content();
            if (content.readableBytes() > 0) {
                ByteBuf readableBytes;
                boolean exceeded = false;
                long remainingTemp = this.remaining;
                if (remainingTemp == -1L) {
                    readableBytes = content;
                } else {
                    long total = content.readableBytes();
                    if ((remainingTemp -= total) >= 0L) {
                        readableBytes = content;
                    } else {
                        remainingTemp = 0L;
                        readableBytes = content.slice(0, (int)(remainingTemp + total));
                        exceeded = true;
                    }
                }
                handle.onData((Buffer)new BufferImpl(readableBytes.duplicate()));
                if (exceeded) {
                    String errMsg = String.format("Content length exceeded %d bytes", this.maxContentLength);
                    this.onError(new ContentOverSizedException(errMsg), true);
                    return;
                }
                this.remaining = remainingTemp;
            }
            if (msg instanceof LastHttpContent) {
                HttpHeaders trailers = ((LastHttpContent)msg).trailingHeaders();
                if (!trailers.isEmpty()) {
                    handle.onTrailers((io.esastack.commons.net.http.HttpHeaders)new Http1HeadersAdaptor(trailers));
                }
                handle.onEnd();
                this.registry.remove(this.reusableRequestId);
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private void onError(Throwable cause, boolean enableLog) {
        Utils.handleH1ChannelEx(this.registry, this.ctx.channel(), this.reusableRequestId, cause, enableLog);
    }

    void updateRequestId(int requestId) {
        Utils.runInChannel(this.ctx.channel(), () -> {
            this.reusableRequestId = requestId;
            this.continue100Received = false;
            this.remaining = -1L;
        });
    }

    HandleRegistry getRegistry() {
        return this.registry;
    }

    private void handleDecodeError(Throwable cause) {
        String errMsg = "Failed to decode response, connection: " + this.ctx.channel();
        this.onError(new ProtocolException(errMsg, cause), true);
    }

    private void handleResponse(ResponseHandle handle, HttpResponse msg) {
        int status = msg.status().code();
        Runnable runnable = handle.ctx().remove100ContinueCallback();
        if (runnable != null) {
            if (status == HttpResponseStatus.CONTINUE.code()) {
                this.continue100Received = true;
                runnable.run();
                return;
            }
            this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        if (this.isContentLengthInvalid((HttpMessage)msg)) {
            String errMsg = String.format("Content length exceeded %d bytes", this.maxContentLength);
            this.onError(new ContentOverSizedException(errMsg), true);
            return;
        }
        handle.onMessage(HttpMessageImpl.from(msg));
    }

    private boolean isContentLengthInvalid(HttpMessage response) {
        if (this.maxContentLength > 0L) {
            long contentLength = -1L;
            try {
                String value = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                if (value != null) {
                    contentLength = Long.parseLong(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (contentLength > 0L) {
                return contentLength > this.maxContentLength;
            }
            this.remaining = this.maxContentLength;
            return false;
        }
        return false;
    }
}

