/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.stream.ChunkedInput;

final class Http2ChunkedInput
implements ChunkedInput<Content> {
    private final ChunkedInput<ByteBuf> input;
    private final int streamId;

    Http2ChunkedInput(ChunkedInput<ByteBuf> input, int streamId) {
        this.input = input;
        this.streamId = streamId;
    }

    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    public void close() throws Exception {
        this.input.close();
    }

    @Deprecated
    public Content readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public Content readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf buf = (ByteBuf)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            return new Content(buf, this.streamId, true);
        }
        return new Content(buf, this.streamId, false);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }

    static class Content
    extends DefaultHttpContent {
        final int streamId;
        final boolean endOfStream;

        Content(ByteBuf content, int streamId, boolean endOfStream) {
            super(content);
            this.streamId = streamId;
            this.endOfStream = endOfStream;
        }
    }
}

