/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.buffer.BufferUtil;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.Http2ChunkedInput;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.BufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ReferenceCounted;

class Http2ConnectionHandler
extends io.netty.handler.codec.http2.Http2ConnectionHandler {
    private final HandleRegistry registry;
    private volatile ChannelHandlerContext ctx;

    Http2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, HandleRegistry registry) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway);
        this.registry = registry;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        ctx.pipeline().addAfter(ctx.name(), "h2ChunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        super.handlerAdded(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2ChunkedInput.Content) {
            boolean hasBody;
            Http2ChunkedInput.Content c = (Http2ChunkedInput.Content)((Object)msg);
            boolean bl = hasBody = c.content().readableBytes() > 0;
            if (hasBody) {
                this.writeData(c.streamId, c.content(), c.endOfStream, promise);
            } else {
                this.writeData(c.streamId, Unpooled.EMPTY_BUFFER, true, promise);
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause) != null) {
                super.exceptionCaught(ctx, cause);
            } else {
                Utils.handleH2ChannelEx(this.registry, ctx.channel(), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!Utils.handleIdleEvt(ctx, evt)) {
            super.userEventTriggered(ctx, evt);
        }
    }

    ChannelFuture writeData(int streamId, Object data, boolean endStream, ChannelPromise promise) {
        if (this.inEventLoop()) {
            return this.writeData0(streamId, data, endStream, promise);
        }
        ChannelPromise promise0 = this.ctx.newPromise();
        Runnable runnable = () -> this.writeData0(streamId, data, endStream, promise).addListener(future -> {
            if (future.isSuccess()) {
                promise0.setSuccess();
            } else {
                promise0.setFailure(future.cause());
            }
        });
        this.ctx.channel().eventLoop().execute(runnable);
        return promise0;
    }

    private ChannelFuture writeData0(int streamId, Object data, boolean endStream, ChannelPromise promise) {
        if (this.checkIfEnded(streamId, false, promise)) {
            this.releaseIfNeed(data);
            return promise;
        }
        ByteBuf buf = null;
        try {
            boolean emptyData;
            if (data != null) {
                buf = this.format(data);
            }
            boolean bl = emptyData = buf == null || buf.readableBytes() == 0;
            if (emptyData && !endStream) {
                return promise.setSuccess();
            }
            return this.encoder().writeData(this.ctx, streamId, buf, 0, endStream, promise);
        }
        catch (Throwable ex) {
            Utils.tryRelease(buf);
            return promise.setFailure(ex);
        }
    }

    ChannelFuture writeHeaders(int streamId, Http2Headers headers, boolean endStream, ChannelPromise promise) {
        if (this.inEventLoop()) {
            return this.writeHeaders0(streamId, headers, endStream, promise);
        }
        ChannelPromise promise0 = this.ctx.newPromise();
        Runnable runnable = () -> this.writeHeaders0(streamId, headers, endStream, promise).addListener(future -> {
            if (future.isSuccess()) {
                promise0.setSuccess();
            } else {
                promise0.setFailure(future.cause());
            }
        });
        this.ctx.channel().eventLoop().execute(runnable);
        return promise0;
    }

    ChannelFuture writeGoAwayOnExhaustion(ChannelPromise promise) {
        ChannelPromise promise0 = this.ctx.newPromise();
        Runnable runnable = () -> this.encoder().writeGoAway(this.ctx, 0x7FFFFFFE, Http2Error.NO_ERROR.code(), ByteBufUtil.writeAscii((ByteBufAllocator)this.ctx.alloc(), (CharSequence)"Stream IDs exhausted on local stream creation"), promise).addListener(future -> {
            if (future.isSuccess()) {
                promise0.setSuccess();
            } else {
                promise0.setFailure(future.cause());
            }
        });
        if (this.inEventLoop()) {
            runnable.run();
        } else {
            this.ctx.channel().eventLoop().execute(runnable);
        }
        return promise0;
    }

    private ChannelFuture writeHeaders0(int streamId, Http2Headers headers, boolean endStream, ChannelPromise promise) {
        if (this.checkIfEnded(streamId, true, promise)) {
            return promise;
        }
        int dependencyId = headers.getInt((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short weight = headers.getShort((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        return this.encoder().writeHeaders(this.ctx, streamId, headers, dependencyId, weight, false, 0, endStream, promise);
    }

    boolean checkIfEnded(int streamId, boolean isHeader, ChannelPromise promise) {
        if (this.registry.get(streamId) == null) {
            promise.setFailure((Throwable)new IllegalStateException("Request may has ended before writing " + (isHeader ? "headers" : "data")));
            return true;
        }
        return false;
    }

    HandleRegistry getRegistry() {
        return this.registry;
    }

    private boolean inEventLoop() {
        return this.ctx.channel().eventLoop().inEventLoop();
    }

    private void releaseIfNeed(Object data) {
        Object unwrap;
        if (data instanceof ByteBuf) {
            Utils.tryRelease((ReferenceCounted)((ByteBuf)data));
        } else if (data instanceof Buffer && (unwrap = BufferUtil.unwrap((Buffer)((Buffer)data))) instanceof ByteBuf) {
            Utils.tryRelease((ReferenceCounted)((ByteBuf)unwrap));
        }
    }

    private ByteBuf format(Object data) {
        if (data instanceof ByteBuf) {
            return (ByteBuf)data;
        }
        if (data instanceof byte[]) {
            ByteBuf buf = this.ctx.alloc().buffer(((byte[])data).length);
            buf.writeBytes((byte[])data);
            return buf;
        }
        if (data instanceof Buffer) {
            return BufferUtils.toByteBuf((Buffer)data);
        }
        throw new IllegalArgumentException("Unsupported writable data format: " + data.getClass() + "(expected ByteBuf, Buffer, byte[])");
    }
}

