/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.netty.buffer.BufferImpl;
import io.esastack.commons.net.netty.http.Http2HeadersAdaptor;
import io.esastack.httpclient.core.exception.ClosedStreamException;
import io.esastack.httpclient.core.exception.ContentOverSizedException;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.HttpMessageImpl;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;

class Http2FrameHandler
extends Http2EventAdapter {
    private final HandleRegistry registry;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey messageKey;
    private final long maxContentLength;

    Http2FrameHandler(HandleRegistry registry, Http2Connection connection, long maxContentLength) {
        Checks.checkNotNull((Object)registry, (String)"registry");
        Checks.checkNotNull((Object)connection, (String)"connection");
        this.connection = connection;
        this.messageKey = connection.newKey();
        this.registry = registry;
        this.connection.addListener((Http2Connection.Listener)this);
        this.maxContentLength = maxContentLength;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        headers.setInt((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId);
        headers.addLong((Object)"$ttfb", System.currentTimeMillis());
        this.onHeaders(streamId, stream, headers, stream.getProperty(this.messageKey) != null, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        if (streamDependency != 0) {
            headers.setInt((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), streamDependency);
        }
        headers.setShort((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), weight);
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        ResponseHandle handle = this.registry.get(streamId);
        if (handle == null) {
            return data.readableBytes() + padding;
        }
        int readableBytes = data.readableBytes();
        if (readableBytes > 0) {
            ByteBuf retainedData;
            boolean exceeded = false;
            if (handle.remaining == -1L) {
                retainedData = data;
            } else {
                handle.remaining -= (long)readableBytes;
                if (handle.remaining >= 0L) {
                    retainedData = data;
                } else {
                    handle.remaining += (long)readableBytes;
                    retainedData = data.slice(0, (int)handle.remaining);
                    exceeded = true;
                    handle.remaining = 0L;
                }
            }
            handle.onData((Buffer)new BufferImpl(retainedData.duplicate()));
            if (exceeded) {
                String errMsg = String.format("Content length exceeded %d bytes", this.maxContentLength);
                this.onError(new ContentOverSizedException(errMsg), null, streamId, true);
                return readableBytes + padding;
            }
        }
        if (endOfStream) {
            handle.onEnd();
            Http2Stream stream = this.connection.stream(streamId);
            if (stream != null) {
                stream.removeProperty(this.messageKey);
            }
            this.registry.remove(streamId);
        }
        return readableBytes + padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream != null) {
            ClosedStreamException ex = ClosedStreamException.CAUSED_BY_RST;
            LoggerUtils.logger().debug(ex.getMessage());
            this.onError(ex, stream, streamId, false);
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Http2Stream promisedStream = this.connection.stream(promisedStreamId);
        if (promisedStream.getProperty(this.messageKey) != null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Push Promise Frame received for pre-existing stream id %d", (Object[])new Object[]{promisedStreamId});
        }
        if (headers.status() == null) {
            headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        }
        headers.setShort((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        headers.setInt((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), streamId);
        this.onHeaders(promisedStreamId, promisedStream, headers, false, false);
    }

    public void onStreamRemoved(Http2Stream stream) {
        ClosedStreamException ex = ClosedStreamException.CAUSED_BY_REMOVED;
        this.onError(ex, stream, -1, false);
    }

    private void onHeaders(int streamId, Http2Stream stream, Http2Headers headers, boolean trailer, boolean endOfStream) throws Http2Exception {
        ResponseHandle handle = this.registry.get(streamId);
        if (handle == null) {
            return;
        }
        HttpResponseStatus status = HttpConversionUtil.parseStatus((CharSequence)headers.status());
        if (HttpStatusClass.INFORMATIONAL == status.codeClass()) {
            stream.removeProperty(this.messageKey);
            if (HttpResponseStatus.CONTINUE.code() == status.code()) {
                this.handle100Continue(handle.ctx());
            }
            return;
        }
        if (!headers.isEmpty()) {
            if (trailer) {
                handle.onTrailers((HttpHeaders)new Http2HeadersAdaptor(Utils.standardHeaders(headers)));
            } else {
                handle.onMessage(HttpMessageImpl.from(headers, streamId));
                if (this.isContentLengthInvalid(headers, handle)) {
                    String errMsg = String.format("Content length exceeded %d bytes", this.maxContentLength);
                    this.onError(new ContentOverSizedException(errMsg), stream, streamId, true);
                    return;
                }
                stream.setProperty(this.messageKey, (Object)true);
            }
        }
        if (endOfStream) {
            stream.removeProperty(this.messageKey);
            handle.onEnd();
            this.registry.remove(streamId);
        }
    }

    private void onError(Throwable cause, Http2Stream stream, int streamId, boolean enableLog) {
        if (stream != null) {
            stream.removeProperty(this.messageKey);
            streamId = stream.id();
        }
        ResponseHandle handle = this.registry.remove(streamId);
        Utils.handleException(handle, cause, enableLog);
    }

    private void handle100Continue(ExecContext ctx) {
        Runnable runnable = ctx.remove100ContinueCallback();
        if (runnable != null) {
            runnable.run();
        }
    }

    private boolean isContentLengthInvalid(Http2Headers headers, ResponseHandle handle) {
        if (this.maxContentLength > 0L) {
            long contentLength;
            try {
                contentLength = headers.getLong((Object)HttpHeaderNames.CONTENT_LENGTH, -1L);
            }
            catch (NumberFormatException ex) {
                contentLength = -1L;
            }
            if (contentLength > this.maxContentLength) {
                return true;
            }
            handle.remaining = contentLength > 0L ? contentLength : this.maxContentLength;
            return false;
        }
        return false;
    }
}

