/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.netty.http.Http1HeadersAdaptor;
import io.esastack.commons.net.netty.http.Http2HeadersAdaptor;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.netty.Utils;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.StringJoiner;

class HttpMessageImpl
implements HttpMessage {
    private final int status;
    private final io.esastack.commons.net.http.HttpVersion version;
    private final HttpHeaders headers;

    HttpMessageImpl(int status, io.esastack.commons.net.http.HttpVersion version, HttpHeaders headers) {
        Checks.checkNotNull((Object)version, (String)"version");
        Checks.checkNotNull((Object)headers, (String)"headers");
        this.status = status;
        this.version = version;
        this.headers = headers;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public io.esastack.commons.net.http.HttpVersion version() {
        return this.version;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    public String toString() {
        return new StringJoiner(", ", HttpMessageImpl.class.getSimpleName() + "[", "]").add("status=" + this.status).add("version=" + this.version).add("headers=" + this.headers).toString();
    }

    static HttpMessage from(HttpResponse message) {
        message.headers().add("$ttfb", (Object)System.currentTimeMillis());
        return new HttpMessageImpl(message.status().code(), HttpVersion.HTTP_1_1 == message.protocolVersion() ? io.esastack.commons.net.http.HttpVersion.HTTP_1_1 : io.esastack.commons.net.http.HttpVersion.HTTP_1_0, (HttpHeaders)new Http1HeadersAdaptor(message.headers()));
    }

    static HttpMessage from(Http2Headers headers, int streamId) {
        try {
            HttpResponseStatus status = HttpConversionUtil.parseStatus((CharSequence)headers.status());
            Utils.standardHeaders(headers);
            return new HttpMessageImpl(status.code(), io.esastack.commons.net.http.HttpVersion.HTTP_2, (HttpHeaders)new Http2HeadersAdaptor(headers));
        }
        catch (Http2Exception ex) {
            throw new RuntimeException(String.format("Error whiling parsing HTTP2 headers, streamId: %d", streamId), ex);
        }
    }
}

