/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.StringUtils;
import esa.commons.concurrent.ThreadFactories;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.Scheme;
import io.esastack.httpclient.core.config.ChannelPoolOptions;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.exec.HttpTransceiver;
import io.esastack.httpclient.core.filter.ResponseFilter;
import io.esastack.httpclient.core.netty.CachedChannelPools;
import io.esastack.httpclient.core.netty.ChannelPool;
import io.esastack.httpclient.core.netty.ChannelPoolFactory;
import io.esastack.httpclient.core.netty.FileWriter;
import io.esastack.httpclient.core.netty.H1TransceiverHandle;
import io.esastack.httpclient.core.netty.H2TransceiverHandle;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.Http1ChannelHandler;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.MultipartWriter;
import io.esastack.httpclient.core.netty.PlainWriter;
import io.esastack.httpclient.core.netty.ReadTimeoutTask;
import io.esastack.httpclient.core.netty.RequestWriter;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.SegmentWriter;
import io.esastack.httpclient.core.netty.ServerSelector;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.spi.ChannelPoolOptionsProvider;
import io.esastack.httpclient.core.util.Futures;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class HttpTransceiverImpl
implements HttpTransceiver {
    private static final String HASHEDWHEELTIMER_TICKDURATION_KEY = "io.esastack.httpclient.hashedWheelTimer.tickDurationMs";
    private static final String HASHEDWHEELTIMER_SIZE_KEY = "io.esastack.httpclient.hashedWheelTimer.size";
    private static final Timer READ_TIMEOUT_TIMER;
    private static final ServerSelector SERVER_SELECTOR;
    private static final H1TransceiverHandle H1_HANDLE;
    private static final H2TransceiverHandle H2_HANDLE;
    private final EventLoopGroup ioThreads;
    private final CachedChannelPools channelPools;
    private final HttpClientBuilder builder;
    private final ChannelPoolFactory channelPoolFactory;
    private final ChannelPoolOptions channelPoolOptions;
    private final ResponseFilter[] rspFilters;

    HttpTransceiverImpl(EventLoopGroup ioThreads, CachedChannelPools channelPools, HttpClientBuilder builder, ChannelPoolOptions channelPoolOptions, ChannelPoolFactory channelPoolFactory) {
        Checks.checkNotNull((Object)ioThreads, (String)"ioThreads");
        Checks.checkNotNull((Object)channelPools, (String)"channelPools");
        Checks.checkNotNull((Object)builder, (String)"builder");
        Checks.checkNotNull((Object)channelPoolOptions, (String)"channelPoolOptions");
        Checks.checkNotNull((Object)channelPoolFactory, (String)"channelPoolFactory");
        this.ioThreads = ioThreads;
        this.channelPools = channelPools;
        this.builder = builder;
        this.channelPoolOptions = channelPoolOptions;
        this.channelPoolFactory = channelPoolFactory;
        this.rspFilters = builder.buildUnmodifiableResponseFilters();
    }

    @Override
    public CompletableFuture<HttpResponse> handle(HttpRequest request, ExecContext execCtx) {
        io.netty.channel.pool.ChannelPool channelPool;
        Context ctx = execCtx.ctx();
        Listener listener = execCtx.listener();
        listener.onFiltersEnd(request, ctx);
        SocketAddress address = HttpTransceiverImpl.selectServer(request, ctx);
        try {
            channelPool = this.getChannelPool(request, execCtx, address);
        }
        catch (Throwable ex) {
            this.onAcquireChannelPoolFailure(request, execCtx, address, ex);
            return Futures.completed(ex);
        }
        listener.onConnectionAttempt(request, ctx, address);
        Future channel = channelPool.acquire();
        CompletableFuture<HttpResponse> response = new CompletableFuture<HttpResponse>();
        channel.addListener(future -> {
            if (future.isSuccess()) {
                this.onAcquireChannelSuccess(request, execCtx, address, channelPool, (Channel)channel.getNow(), response);
            } else {
                this.onAcquireChannelFailure(request, address, execCtx, response, future.cause());
            }
        });
        return response;
    }

    protected io.netty.channel.pool.ChannelPool getChannelPool(HttpRequest request, ExecContext execCtx, SocketAddress address) {
        io.netty.channel.pool.ChannelPool underlying;
        ChannelPool channelPool;
        execCtx.listener().onConnectionPoolAttempt(request, execCtx.ctx(), address);
        boolean keepAlive = this.isKeepAlive(request);
        ChannelPool channelPool2 = channelPool = keepAlive ? this.channelPools.getIfPresent(address) : null;
        if (channelPool != null) {
            underlying = channelPool.underlying;
        } else {
            boolean ssl = Scheme.HTTPS.name0().equals(request.scheme());
            underlying = this.channelPools.getOrCreate((boolean)keepAlive, (SocketAddress)address, (Function<SocketAddress, ChannelPool>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getChannelPool$1(boolean boolean java.net.SocketAddress java.net.SocketAddress ), (Ljava/net/SocketAddress;)Lio/esastack/httpclient/core/netty/ChannelPool;)((HttpTransceiverImpl)this, (boolean)ssl, (boolean)keepAlive, (SocketAddress)address)).underlying;
        }
        execCtx.listener().onConnectionPoolAcquired(request, execCtx.ctx(), address);
        return underlying;
    }

    protected void onAcquireChannelPoolFailure(HttpRequest request, ExecContext execCtx, SocketAddress address, Throwable cause) {
        execCtx.listener().onAcquireConnectionPoolFailed(request, execCtx.ctx(), address, cause);
    }

    protected void onAcquireChannelSuccess(HttpRequest request, ExecContext execCtx, SocketAddress address, io.netty.channel.pool.ChannelPool channelPool, Channel channel, CompletableFuture<HttpResponse> response) {
        io.esastack.commons.net.http.HttpVersion version;
        execCtx.listener().onConnectionAcquired(request, execCtx.ctx(), address);
        boolean http2 = this.isHttp2(channel);
        if (http2) {
            version = io.esastack.commons.net.http.HttpVersion.HTTP_2;
        } else {
            io.esastack.commons.net.http.HttpVersion httpVersion = version = io.esastack.commons.net.http.HttpVersion.HTTP_1_0 == this.builder.version() ? io.esastack.commons.net.http.HttpVersion.HTTP_1_0 : io.esastack.commons.net.http.HttpVersion.HTTP_1_1;
        }
        if (!channel.isActive()) {
            this.onChannelInactive(request, execCtx, channel, channelPool, response);
            return;
        }
        if (!channel.isWritable()) {
            this.onChannelUnWritable(request, execCtx, channel, channelPool, response);
            return;
        }
        try {
            HandleRegistry registry = this.detectRegistry(channel);
            this.doWrite(request, execCtx, http2, version, channel, channelPool, registry, response);
        }
        catch (Throwable th) {
            channelPool.release(channel);
            this.completeExceptionally(request, execCtx, response, th);
        }
    }

    protected void onAcquireChannelFailure(HttpRequest request, SocketAddress address, ExecContext execCtx, CompletableFuture<HttpResponse> response, Throwable cause) {
        ConnectException ex = new ConnectException(cause.getMessage());
        response.completeExceptionally(ex);
        execCtx.listener().onAcquireConnectionFailed(request, execCtx.ctx(), address, ex);
    }

    protected void onChannelInactive(HttpRequest request, ExecContext execContext, Channel channel, io.netty.channel.pool.ChannelPool channelPool, CompletableFuture<HttpResponse> response) {
        channel.close();
        channelPool.release(channel);
        this.completeExceptionally(request, execContext, response, Utils.CONNECT_INACTIVE);
    }

    protected void onChannelUnWritable(HttpRequest request, ExecContext execContext, Channel channel, io.netty.channel.pool.ChannelPool channelPool, CompletableFuture<HttpResponse> response) {
        channelPool.release(channel);
        this.completeExceptionally(request, execContext, response, Utils.WRITE_BUF_IS_FULL);
    }

    protected void doWrite(HttpRequest request, ExecContext execCtx, boolean http2, io.esastack.commons.net.http.HttpVersion version, Channel channel, io.netty.channel.pool.ChannelPool channelPool, HandleRegistry registry, CompletableFuture<HttpResponse> response) {
        TimeoutHandle handle = this.buildTimeoutHandle(http2, channel, channelPool, execCtx.listener(), version);
        this.setKeepAliveIfNecessary((Http1HeadersImpl)request.headers(), version);
        int requestId = this.addRspHandle(request, execCtx, channel, http2, registry, handle, response);
        try {
            handle.onWriteAttempt(request, execCtx.ctx());
            RequestWriter writer = this.detectWriter(request);
            ChannelPromise headFuture = channel.newPromise();
            ChannelFuture endFuture = writer.writeAndFlush(request, channel, execCtx, headFuture, request.uriEncode(), io.esastack.commons.net.http.HttpVersion.HTTP_1_1 == version ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0, http2);
            this.afterWriting(requestId, request, execCtx, writer, (ChannelFuture)headFuture, endFuture, handle, registry, response);
        }
        catch (Throwable th) {
            this.tryToCleanAndEndExceptionally(request, execCtx, requestId, registry, handle, response, th);
        }
    }

    protected void afterWriting(int requestId, HttpRequest request, ExecContext execCtx, RequestWriter writer, ChannelFuture headFuture, ChannelFuture endFuture, TimeoutHandle handle, HandleRegistry registry, CompletableFuture<HttpResponse> response) {
        Timeout timeout = READ_TIMEOUT_TIMER.newTimeout((TimerTask)new ReadTimeoutTask(requestId, request.uri().toString(), request.readTimeout(), headFuture.channel(), registry), TimeUnit.MILLISECONDS.toNanos(request.readTimeout()), TimeUnit.NANOSECONDS);
        handle.addTimeoutTask(timeout);
        headFuture.addListener(future -> {
            if (!headFuture.isSuccess()) {
                ConnectException cause = new ConnectException(headFuture.cause().getMessage());
                handle.onWriteFailed(request, execCtx.ctx(), headFuture.cause());
                this.tryToCleanAndEndExceptionally(request, execCtx, requestId, registry, handle, response, cause);
            } else {
                endFuture.addListener(future1 -> this.onWriteDone(request, execCtx, requestId, registry, headFuture.channel(), future, future1, handle, response));
            }
        });
    }

    private void onWriteDone(HttpRequest request, ExecContext execCtx, int requestId, HandleRegistry registry, Channel channel, Future<?> headFuture, Future<?> endFuture, TimeoutHandle handle, CompletableFuture<HttpResponse> response) {
        if (headFuture.isSuccess() && endFuture.isSuccess()) {
            handle.onWriteDone(request, execCtx.ctx());
            return;
        }
        IOException cause = new IOException("Failed to write request: " + request + " to connection: " + channel, endFuture.cause());
        handle.onWriteFailed(request, execCtx.ctx(), endFuture.cause());
        this.tryToCleanAndEndExceptionally(request, execCtx, requestId, registry, handle, response, cause);
    }

    protected void completeExceptionally(HttpRequest request, ExecContext execCtx, CompletableFuture<HttpResponse> response, Throwable cause) {
        response.completeExceptionally(cause);
        execCtx.listener().onError(request, execCtx.ctx(), cause);
    }

    protected void tryToCleanAndEndExceptionally(HttpRequest request, ExecContext execCtx, int requestId, HandleRegistry registry, TimeoutHandle handle, CompletableFuture<HttpResponse> response, Throwable cause) {
        if (registry != null && requestId != -1) {
            ResponseHandle handle0 = registry.remove(requestId);
            if (handle0 != null) {
                handle0.onError(cause);
            }
            return;
        }
        if (response.completeExceptionally(cause)) {
            handle.onError(request, execCtx.ctx(), cause);
        }
    }

    protected RequestWriter detectWriter(HttpRequest request) {
        if (request.isSegmented()) {
            return new SegmentWriter();
        }
        if (request.isMultipart()) {
            return MultipartWriter.singleton();
        }
        if (request.file() != null) {
            return FileWriter.singleton();
        }
        return PlainWriter.singleton();
    }

    ChannelPoolOptions detectOptions(SocketAddress address) {
        ChannelPoolOptions channelPoolOptions = null;
        ChannelPoolOptionsProvider provider = this.builder.channelPoolOptionsProvider();
        if (provider != null) {
            channelPoolOptions = provider.get(address);
        }
        if (channelPoolOptions != null) {
            return channelPoolOptions;
        }
        return this.channelPoolOptions;
    }

    static void closeTimer() {
        long start = System.nanoTime();
        Set tasks = READ_TIMEOUT_TIMER.stop();
        LoggerUtils.logger().info("Begin to close readTimeout-Timer, unfinished tasks size: {}", (Object)tasks.size());
        for (Timeout item : tasks) {
            if (!(item.task() instanceof ReadTimeoutTask)) continue;
            ((ReadTimeoutTask)item.task()).cancel();
        }
        LoggerUtils.logger().info("Closed readTimeout-Timer successfully and all unfinished tasks has been canceled, time elapsed: {}", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private boolean isHttp2(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        return pipeline.get(Http2ConnectionHandler.class) != null;
    }

    private boolean isKeepAlive(HttpRequest request) {
        String value = request.headers().get("connection");
        if (!StringUtils.isEmpty((String)value)) {
            if ("close".equalsIgnoreCase(value)) {
                return false;
            }
            if ("keep-alive".equalsIgnoreCase(value)) {
                return true;
            }
        }
        return this.builder.isKeepAlive();
    }

    private TimeoutHandle buildTimeoutHandle(boolean http2, Channel channel, io.netty.channel.pool.ChannelPool channelPool, Listener delegate, io.esastack.commons.net.http.HttpVersion version) {
        if (http2) {
            return H2_HANDLE.buildTimeoutHandle(channel, channelPool, delegate, io.esastack.commons.net.http.HttpVersion.HTTP_2);
        }
        return H1_HANDLE.buildTimeoutHandle(channel, channelPool, delegate, version);
    }

    private int addRspHandle(HttpRequest request, ExecContext execCtx, Channel channel, boolean http2, HandleRegistry registry, TimeoutHandle handle, CompletableFuture<HttpResponse> response) {
        if (http2) {
            return H2_HANDLE.addRspHandle(request, execCtx, channel, this.rspFilters, registry, handle, response);
        }
        return H1_HANDLE.addRspHandle(request, execCtx, channel, this.rspFilters, registry, handle, response);
    }

    private HandleRegistry detectRegistry(Channel channel) throws ConnectException {
        ChannelPipeline pipeline = channel.pipeline();
        Http1ChannelHandler handler1 = (Http1ChannelHandler)pipeline.get(Http1ChannelHandler.class);
        if (handler1 != null) {
            return handler1.getRegistry();
        }
        Http2ConnectionHandler handler2 = (Http2ConnectionHandler)pipeline.get(Http2ConnectionHandler.class);
        if (handler2 != null) {
            return handler2.getRegistry();
        }
        throw Utils.CONNECT_INACTIVE;
    }

    private static SocketAddress selectServer(HttpRequest request, Context ctx) {
        return SERVER_SELECTOR.select(request, ctx);
    }

    private void setKeepAliveIfNecessary(Http1HeadersImpl headers, io.esastack.commons.net.http.HttpVersion version) {
        if (io.esastack.commons.net.http.HttpVersion.HTTP_2 == this.builder.version()) {
            headers.remove("connection");
        }
        if (headers.contains("connection")) {
            return;
        }
        boolean keepAlive = this.builder.isKeepAlive();
        HttpUtil.setKeepAlive((HttpHeaders)headers, (HttpVersion)(io.esastack.commons.net.http.HttpVersion.HTTP_1_1 == version ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0), (boolean)keepAlive);
    }

    private /* synthetic */ ChannelPool lambda$getChannelPool$1(boolean ssl, boolean keepAlive, SocketAddress address, SocketAddress addr) {
        return this.channelPoolFactory.create(ssl, keepAlive, addr, this.ioThreads, this.detectOptions(address), this.builder);
    }

    static {
        SERVER_SELECTOR = ServerSelector.DEFAULT;
        H1_HANDLE = new H1TransceiverHandle();
        H2_HANDLE = new H2TransceiverHandle();
        READ_TIMEOUT_TIMER = new HashedWheelTimer(ThreadFactories.namedThreadFactory((String)"ESAHttpClient-ReadTimout-Checker-", (boolean)true), SystemPropertyUtil.getLong((String)HASHEDWHEELTIMER_TICKDURATION_KEY, (long)30L), TimeUnit.MILLISECONDS, SystemPropertyUtil.getInt((String)HASHEDWHEELTIMER_SIZE_KEY, (int)512));
    }
}

