/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.httpclient.core.IdentityFactory;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

class IdentityFactoryProvider {
    private static final IdentityFactory<EventLoopGroup> IO_THREADS_IDENTITY_FACTORY = new IdentityFactory<EventLoopGroup>(){
        private static final String PREFIX = "IO-Threads-Pool-";
        private final AtomicInteger index = new AtomicInteger();

        @Override
        public IdentityFactory.Identified<EventLoopGroup> generate(EventLoopGroup value) {
            return new IdentityFactory.Identified<EventLoopGroup>(value, PREFIX + this.index.incrementAndGet());
        }
    };
    private static final IdentityFactory<ThreadPoolExecutor> CALLBACK_EXECUTOR_IDENTITY_FACTORY = new IdentityFactory<ThreadPoolExecutor>(){
        private static final String PREFIX = "Callback-Executor-";
        private final AtomicInteger index = new AtomicInteger();

        @Override
        public IdentityFactory.Identified<ThreadPoolExecutor> generate(ThreadPoolExecutor value) {
            return new IdentityFactory.Identified<ThreadPoolExecutor>(value, PREFIX + this.index.incrementAndGet());
        }
    };

    private IdentityFactoryProvider() {
    }

    static IdentityFactory<EventLoopGroup> ioThreadsIdentityFactory() {
        return IO_THREADS_IDENTITY_FACTORY;
    }

    static IdentityFactory<ThreadPoolExecutor> callbackExecutorIdentityFactory() {
        return CALLBACK_EXECUTOR_IDENTITY_FACTORY;
    }
}

