/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.collection.MultiValueMap;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.MultipartFileItem;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.Http2ChunkedInput;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.RequestWriterImpl;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.HttpHeadersUtils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class MultipartWriter
extends RequestWriterImpl {
    private static final String MEMORY_THRESHOLD_KEY = "io.esastack.httpclient.multipart.memoryThreshold";
    private static final String TEMP_DIR_KEY = "io.esastack.httpclient.multipart.tempDir";
    private static final long MEMORY_THRESHOLD = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.multipart.memoryThreshold", (long)2076672L);
    private static final String TEMP_DIR = SystemPropertyUtil.get((String)"io.esastack.httpclient.multipart.tempDir");
    private static final MultipartWriter INSTANCE = new MultipartWriter();
    private static final HttpDataFactory FACTORY = new DefaultHttpDataFactory(MEMORY_THRESHOLD);

    @Override
    ChannelFuture writeAndFlush1(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, HttpVersion version, boolean uriEncodeEnabled) {
        DefaultHttpRequest request0 = new DefaultHttpRequest(version, HttpMethod.POST, request.uri().relative(uriEncodeEnabled), (HttpHeaders)((Http1HeadersImpl)request.headers()));
        ChannelPromise endPromise = channel.newPromise();
        Runnable runnable = () -> MultipartWriter.lambda$writeAndFlush1$0(request, (io.netty.handler.codec.http.HttpRequest)request0, channel, execCtx, headFuture, endPromise);
        Utils.runInChannel(channel, runnable);
        return endPromise;
    }

    private static void encodeAndWrite1(HttpRequest request, io.netty.handler.codec.http.HttpRequest request0, Channel channel, ExecContext execCtx, ChannelPromise headFuture, ChannelPromise endPromise) throws IOException {
        try {
            HttpPostRequestEncoder encoder = MultipartWriter.buildEncoder(request0, request);
            io.netty.handler.codec.http.HttpRequest finalizedRequest = encoder.finalizeRequest();
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("Send Request:\n" + finalizedRequest.headers());
            }
            channel.write((Object)request0, headFuture);
            Runnable writeContent = () -> {
                if (encoder.isChunked()) {
                    channel.writeAndFlush((Object)encoder, endPromise);
                } else {
                    DefaultLastHttpContent last = new DefaultLastHttpContent(((FullHttpRequest)finalizedRequest).content());
                    last.trailingHeaders().add(((FullHttpRequest)finalizedRequest).trailingHeaders());
                    channel.writeAndFlush((Object)last, endPromise);
                }
            };
            if (MultipartWriter.writeContentNow(execCtx, request)) {
                writeContent.run();
            } else {
                channel.flush();
                execCtx.set100ContinueCallback(() -> Utils.runInChannel(channel, writeContent));
            }
            MultipartWriter.doClean(endPromise, encoder);
        }
        catch (Exception ex) {
            FACTORY.cleanRequestHttpData(request0);
            throw new IOException(ex);
        }
    }

    @Override
    ChannelFuture writeAndFlush2(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, Http2ConnectionHandler handler, int streamId, boolean uriEncodeEnabled) {
        DefaultHttpRequest request0 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.method().name()), request.uri().relative(uriEncodeEnabled), (HttpHeaders)((Http1HeadersImpl)request.headers()));
        ChannelPromise endPromise = channel.newPromise();
        Runnable runnable = () -> this.lambda$writeAndFlush2$3(request, channel, handler, streamId, (io.netty.handler.codec.http.HttpRequest)request0, execCtx, uriEncodeEnabled, headFuture, endPromise);
        Utils.runInChannel(channel, runnable);
        return endPromise;
    }

    private void encodeAndWrite2(HttpRequest request, Channel channel, Http2ConnectionHandler handler, int streamId, io.netty.handler.codec.http.HttpRequest request0, ExecContext execCtx, boolean uriEncodeEnabled, ChannelPromise headFuture, ChannelPromise endPromise) throws IOException {
        try {
            HttpPostRequestEncoder encoder = MultipartWriter.buildEncoder(request0, request);
            io.netty.handler.codec.http.HttpRequest finalizedRequest = encoder.finalizeRequest();
            ChannelFuture future = this.checkAndWriteH2Headers(channel, handler, HttpHeadersUtils.toHttp2Headers(request, (Http1HeadersImpl)request.headers(), uriEncodeEnabled), streamId, false, headFuture);
            if (future.isDone() && !future.isSuccess()) {
                endPromise.setFailure(future.cause());
                return;
            }
            Runnable writeContent = () -> {
                if (!encoder.isChunked()) {
                    handler.writeData(streamId, ((FullHttpRequest)finalizedRequest).content(), true, endPromise);
                    channel.flush();
                } else {
                    channel.writeAndFlush((Object)new Http2ChunkedInput(new HttpContentToByteBuf((ChunkedInput)encoder), streamId), endPromise);
                }
            };
            if (!MultipartWriter.writeContentNow(execCtx, request)) {
                channel.flush();
                execCtx.set100ContinueCallback(() -> Utils.runInChannel(channel, writeContent));
            } else {
                writeContent.run();
            }
            MultipartWriter.doClean(endPromise, encoder);
        }
        catch (Exception ex) {
            FACTORY.cleanRequestHttpData(request0);
            throw new IOException(ex);
        }
    }

    private static void doClean(ChannelPromise promise, HttpPostRequestEncoder encoder) {
        if (promise.isDone()) {
            try {
                encoder.cleanFiles();
            }
            catch (Throwable throwable) {
                LoggerUtils.logger().error("Failed to clean multipart items", throwable);
            }
        } else {
            promise.addListener(f -> {
                try {
                    encoder.cleanFiles();
                }
                catch (Throwable throwable) {
                    LoggerUtils.logger().error("Failed to clean multipart items", throwable);
                }
            });
        }
    }

    private static HttpPostRequestEncoder buildEncoder(io.netty.handler.codec.http.HttpRequest request0, HttpRequest request) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder(FACTORY, request0, request.multipartEncode());
        MultiValueMap<String, String> attributes = request.attrs();
        for (Map.Entry entry : attributes.entrySet()) {
            for (String value : (List)entry.getValue()) {
                encoder.addBodyAttribute((String)entry.getKey(), value);
            }
        }
        for (MultipartFileItem item : request.files()) {
            encoder.addBodyFileUpload(item.name(), item.fileName(), item.file(), item.contentType(), item.isText());
        }
        return encoder;
    }

    private MultipartWriter() {
    }

    static MultipartWriter singleton() {
        return INSTANCE;
    }

    private /* synthetic */ void lambda$writeAndFlush2$3(HttpRequest request, Channel channel, Http2ConnectionHandler handler, int streamId, io.netty.handler.codec.http.HttpRequest request0, ExecContext execCtx, boolean uriEncodeEnabled, ChannelPromise headFuture, ChannelPromise endPromise) {
        try {
            this.encodeAndWrite2(request, channel, handler, streamId, request0, execCtx, uriEncodeEnabled, headFuture, endPromise);
        }
        catch (IOException e) {
            endPromise.setFailure((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$writeAndFlush1$0(HttpRequest request, io.netty.handler.codec.http.HttpRequest request0, Channel channel, ExecContext execCtx, ChannelPromise headFuture, ChannelPromise endPromise) {
        try {
            MultipartWriter.encodeAndWrite1(request, request0, channel, execCtx, headFuture, endPromise);
        }
        catch (IOException e) {
            endPromise.setFailure((Throwable)e);
        }
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = TEMP_DIR;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = TEMP_DIR;
    }

    private static final class HttpContentToByteBuf
    implements ChunkedInput<ByteBuf> {
        private final ChunkedInput<HttpContent> delegating;

        private HttpContentToByteBuf(ChunkedInput<HttpContent> delegating) {
            this.delegating = delegating;
        }

        public boolean isEndOfInput() throws Exception {
            return this.delegating.isEndOfInput();
        }

        public void close() throws Exception {
            this.delegating.close();
        }

        @Deprecated
        public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
            HttpContent content = (HttpContent)this.delegating.readChunk(allocator);
            if (content == null) {
                return Unpooled.EMPTY_BUFFER;
            }
            return content.content();
        }

        public long length() {
            return this.delegating.length();
        }

        public long progress() {
            return this.delegating.progress();
        }
    }
}

