/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.commons.Platforms;
import esa.commons.annotation.Internal;
import esa.commons.concurrent.ThreadPools;
import esa.commons.reflect.BeanUtils;
import esa.commons.spi.SpiLoader;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.CompositeRequest;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.HttpClient;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpRequestFacade;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.IdentityFactory;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.ListenerProxy;
import io.esastack.httpclient.core.ModifiableClient;
import io.esastack.httpclient.core.config.CallbackThreadPoolOptions;
import io.esastack.httpclient.core.config.ChannelPoolOptions;
import io.esastack.httpclient.core.config.Decompression;
import io.esastack.httpclient.core.config.SslOptions;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.exec.RequestExecutor;
import io.esastack.httpclient.core.exec.RequestExecutorImpl;
import io.esastack.httpclient.core.metrics.CallbackExecutorMetric;
import io.esastack.httpclient.core.metrics.ConnectionPoolMetric;
import io.esastack.httpclient.core.metrics.ConnectionPoolMetricProvider;
import io.esastack.httpclient.core.metrics.IoThreadGroupMetric;
import io.esastack.httpclient.core.metrics.IoThreadMetric;
import io.esastack.httpclient.core.netty.CachedChannelPools;
import io.esastack.httpclient.core.netty.ChannelPool;
import io.esastack.httpclient.core.netty.ChannelPoolFactory;
import io.esastack.httpclient.core.netty.HttpTransceiverImpl;
import io.esastack.httpclient.core.netty.IdentityFactoryProvider;
import io.esastack.httpclient.core.netty.NettyTransceiver;
import io.esastack.httpclient.core.netty.SegmentRequestImpl;
import io.esastack.httpclient.core.netty.SslEngineFactoryImpl;
import io.esastack.httpclient.core.netty.ThreadFactoryImpl;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.spi.SslEngineFactory;
import io.esastack.httpclient.core.util.BufferUtils;
import io.esastack.httpclient.core.util.Futures;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.SocketAddress;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

@Internal
public class NettyHttpClient
implements HttpClient,
ModifiableClient<NettyHttpClient> {
    private static final String IOTHREADS_KYE = "io.esastack.httpclient.ioThreads";
    private static final int IOTHREADS = SystemPropertyUtil.getInt((String)"io.esastack.httpclient.ioThreads", (int)Math.min(Platforms.cpuNum() << 1, 16));
    private static final String CLOSE_CONNECTION_POOL_DELAY_SECONDS_KEY = "io.esastack.httpclient.closeConnectionPoolDelaySeconds";
    private static final long CLOSE_CHANNEL_POOL_DELAY_SECONDS = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.closeConnectionPoolDelaySeconds", (long)120L);
    private static final String IOTHREADS_GRACEFULLY_SHUTDOWN_QUIET_PERIOD_KEY = "io.esastack.httpclient.ioThreadsGracefullyShutdownQuietPeriod";
    private static final long IOTHREADS_GRACEFULLY_SHUTDOWN_QUIET_PERIOD = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.ioThreadsGracefullyShutdownQuietPeriod", (long)2L);
    private static final String IOTHREADS_GRACEFULLY_SHUTDOWN_TIMEOUT_SECONDS_KEY = "io.esastack.httpclient.ioThreadsGracefullyShutdownTimeoutSeconds";
    private static final long IOTHREADS_GRACEFULLY_SHUTDOWN_TIMEOUT_SECONDS = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.ioThreadsGracefullyShutdownTimeoutSeconds", (long)15L);
    private static final String IDENTITY_PREFIX = "ESAHttpClient-";
    private static final AtomicInteger IDENTITY = new AtomicInteger();
    private static final AtomicInteger ACTIVE_CLIENTS = new AtomicInteger();
    private static final IdentityFactory.Identified<ThreadPoolExecutor> SHARED_CALLBACK_EXECUTOR = IdentityFactoryProvider.callbackExecutorIdentityFactory().generate(NettyHttpClient.newCallbackExecutor(CallbackThreadPoolOptions.ofDefault()));
    private static final IdentityFactory.Identified<EventLoopGroup> SHARED_IO_THREADS = IdentityFactoryProvider.ioThreadsIdentityFactory().generate(NettyHttpClient.sharedIoThreads());
    protected final HttpClientBuilder builder;
    private final CachedChannelPools channelPools;
    private final IdentityFactory.Identified<EventLoopGroup> ioThreads;
    private final IdentityFactory.Identified<ThreadPoolExecutor> callbackExecutor;
    private final String id;
    private volatile RequestExecutor executor;
    private final ChannelPoolFactory channelPoolFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public NettyHttpClient(HttpClientBuilder builder, CachedChannelPools channelPools) {
        this(builder, channelPools, SHARED_IO_THREADS, SHARED_CALLBACK_EXECUTOR);
    }

    private NettyHttpClient(HttpClientBuilder builder, CachedChannelPools channelPools, IdentityFactory.Identified<EventLoopGroup> ioThreads, IdentityFactory.Identified<ThreadPoolExecutor> callbackExecutor) {
        Checks.checkNotNull((Object)builder, (String)"builder");
        Checks.checkNotNull(ioThreads, (String)"ioThreads");
        Checks.checkNotNull((Object)channelPools, (String)"channelPools");
        this.builder = builder;
        this.callbackExecutor = callbackExecutor;
        this.ioThreads = ioThreads;
        this.channelPools = channelPools;
        this.id = IDENTITY_PREFIX + IDENTITY.incrementAndGet();
        this.channelPoolFactory = new ChannelPoolFactory(this.loadSslEngineFactory(builder.sslOptions()));
        this.executor = this.build(ioThreads.origin(), channelPools, this.buildOptions(builder));
        ACTIVE_CLIENTS.incrementAndGet();
    }

    @Override
    public HttpRequestFacade get(String uri) {
        return this.newRequestFacade(HttpMethod.GET, uri);
    }

    @Override
    public HttpRequestFacade head(String uri) {
        return this.newRequestFacade(HttpMethod.HEAD, uri);
    }

    @Override
    public HttpRequestFacade options(String uri) {
        return this.newRequestFacade(HttpMethod.OPTIONS, uri);
    }

    @Override
    public HttpRequestFacade trace(String uri) {
        return this.newRequestFacade(HttpMethod.TRACE, uri);
    }

    @Override
    public HttpRequestFacade connect(String uri) {
        return this.newRequestFacade(HttpMethod.CONNECT, uri);
    }

    @Override
    public HttpRequestFacade post(String uri) {
        return this.newRequestFacade(HttpMethod.POST, uri);
    }

    @Override
    public HttpRequestFacade delete(String uri) {
        return this.newRequestFacade(HttpMethod.DELETE, uri);
    }

    @Override
    public HttpRequestFacade put(String uri) {
        return this.newRequestFacade(HttpMethod.PUT, uri);
    }

    @Override
    public HttpRequestFacade patch(String uri) {
        return this.newRequestFacade(HttpMethod.PATCH, uri);
    }

    public CompletableFuture<HttpResponse> execute(HttpRequest request, Context ctx, Consumer<Handle> handle, Handler handler) {
        Checks.checkNotNull((Object)request, (String)"request");
        Checks.checkNotNull((Object)ctx, (String)"ctx");
        Listener listener = ListenerProxy.DEFAULT;
        this.addAcceptEncodingIfAbsent(request);
        CompletionStage<HttpResponse> response = this.executor.execute(request, new ExecContext(ctx, listener, handle, handler));
        if (request.buffer() != null) {
            response = ((CompletableFuture)response).whenComplete((rsp, th) -> Utils.tryRelease((ReferenceCounted)BufferUtils.toByteBuf(request.buffer())));
        }
        if (this.callbackExecutor.origin() == null) {
            return response;
        }
        return ((CompletableFuture)response).thenComposeAsync(Futures::completed, (Executor)this.callbackExecutor.origin());
    }

    @Override
    public ConnectionPoolMetricProvider connectionPoolMetric() {
        return this.channelPools;
    }

    @Override
    public IoThreadGroupMetric ioThreadsMetric() {
        if (this.ioThreads.origin() instanceof MultithreadEventLoopGroup) {
            return new IoThreadGroupMetricImpl((MultithreadEventLoopGroup)this.ioThreads.origin(), this.ioThreads.id());
        }
        return null;
    }

    @Override
    public CallbackExecutorMetric callbackExecutorMetric() {
        if (this.callbackExecutor.origin() == null) {
            return null;
        }
        return new CallbackExecutorMetricImpl(this.callbackExecutor.origin(), this.callbackExecutor.id());
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ACTIVE_CLIENTS.decrementAndGet();
            this.channelPools.close();
            this.channelPoolFactory.sslEngineFactory.onDestroy();
            if (ACTIVE_CLIENTS.intValue() == 0) {
                NettyHttpClient.closeGlobalGracefully();
            }
        }
    }

    private HttpRequestFacade newRequestFacade(HttpMethod method, String uri) {
        Checks.checkNotNull((Object)method, (String)"method");
        Checks.checkNotEmptyArg((String)uri, (String)"uri");
        return new CompositeRequest(this.builder, this, () -> new SegmentRequestImpl(this.builder, this.executor, method, uri), method, uri);
    }

    private static void closeGlobalGracefully() {
        try {
            Utils.CLOSE_CONNECTION_POOL_SCHEDULER.shutdown();
            Utils.CLOSE_CONNECTION_POOL_SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS);
            List<Runnable> unfinishedTasks = Utils.CLOSE_CONNECTION_POOL_SCHEDULER.shutdownNow();
            String msg = "Closed NettyHttpClient-CloseConnectionPool-Scheduler-ThreadPool successfully, unfinished tasks: " + unfinishedTasks.size();
            if (unfinishedTasks.isEmpty()) {
                LoggerUtils.logger().info(msg);
            } else {
                LoggerUtils.logger().error(msg);
            }
        }
        catch (Throwable ex) {
            LoggerUtils.logger().error("Error while closing NettyHttpClient-CloseConnectionPool-Scheduler-ThreadPool", ex);
        }
        if (SHARED_IO_THREADS.origin() != null) {
            try {
                SHARED_IO_THREADS.origin().shutdownGracefully(IOTHREADS_GRACEFULLY_SHUTDOWN_QUIET_PERIOD, IOTHREADS_GRACEFULLY_SHUTDOWN_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            }
            catch (Throwable ex) {
                LoggerUtils.logger().error("Error while closing IO-Threads", ex);
            }
        }
        if (SHARED_CALLBACK_EXECUTOR.origin() != null) {
            try {
                SHARED_CALLBACK_EXECUTOR.origin().shutdown();
                long gracefullyShutdownSeconds = CallbackThreadPoolOptions.ofDefault().gracefullyShutdownSeconds();
                if (gracefullyShutdownSeconds > 0L) {
                    SHARED_CALLBACK_EXECUTOR.origin().awaitTermination(gracefullyShutdownSeconds, TimeUnit.SECONDS);
                }
                List<Runnable> unfinishedTasks = SHARED_CALLBACK_EXECUTOR.origin().shutdownNow();
                String msg = "Closed Callback-Executor-ThreadPool successfully, unfinished tasks: " + unfinishedTasks.size();
                if (unfinishedTasks.isEmpty()) {
                    LoggerUtils.logger().info(msg);
                } else {
                    LoggerUtils.logger().error(msg);
                }
            }
            catch (Throwable ex) {
                LoggerUtils.logger().error("Error while closing Callback-Executor-ThreadPool", ex);
            }
        }
        HttpTransceiverImpl.closeTimer();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public synchronized NettyHttpClient applyChannelPoolOptions(ChannelPoolOptions options, boolean applyToExisted) {
        Checks.checkNotNull((Object)options, (String)"options");
        if (options.connectTimeout() == this.builder.connectTimeout() && options.readTimeout() == this.builder.readTimeout() && options.poolSize() == this.builder.connectionPoolSize() && options.waitingQueueLength() == this.builder.connectionPoolWaitingQueueLength()) {
            return this;
        }
        this.executor = this.build(this.ioThreads.origin(), this.channelPools, options);
        if (!applyToExisted) {
            return this;
        }
        Map<SocketAddress, ConnectionPoolMetric> metrics = this.channelPools.all();
        metrics.forEach((addr, opt) -> {
            if (!options.equals(opt.options())) {
                this.applyChannelPoolOptions(this.channelPools.getIfPresent((SocketAddress)addr), (SocketAddress)addr, options);
            }
        });
        return this;
    }

    @Override
    public synchronized NettyHttpClient applyChannelPoolOptions(Map<SocketAddress, ChannelPoolOptions> options) {
        if (options == null || options.isEmpty()) {
            return this;
        }
        for (Map.Entry<SocketAddress, ChannelPoolOptions> entry : options.entrySet()) {
            ChannelPool pre = this.channelPools.getIfPresent(entry.getKey());
            if (pre == null || pre.options.equals(entry.getValue())) continue;
            this.applyChannelPoolOptions(pre, entry.getKey(), entry.getValue());
        }
        return this;
    }

    private void applyChannelPoolOptions(ChannelPool old, SocketAddress address, ChannelPoolOptions options) {
        if (old == null) {
            return;
        }
        this.channelPools.put(address, this.channelPoolFactory.create(old.ssl, true, address, this.ioThreads.origin(), options, this.builder));
        Utils.CLOSE_CONNECTION_POOL_SCHEDULER.schedule(() -> CachedChannelPools.close(address, old, true), CLOSE_CHANNEL_POOL_DELAY_SECONDS, TimeUnit.SECONDS);
    }

    private ChannelPoolOptions buildOptions(HttpClientBuilder builder) {
        return ChannelPoolOptions.options().connectTimeout(builder.connectTimeout()).readTimeout(builder.readTimeout()).poolSize(builder.connectionPoolSize()).waitingQueueLength(builder.connectionPoolWaitingQueueLength()).build();
    }

    protected RequestExecutor build(EventLoopGroup ioThreads, CachedChannelPools channelPools, ChannelPoolOptions channelPoolOptions) {
        NettyTransceiver transceiver = new NettyTransceiver(ioThreads, channelPools, this.builder, channelPoolOptions, this.channelPoolFactory);
        return new RequestExecutorImpl(this.builder.unmodifiableInterceptors(), transceiver);
    }

    static ThreadPoolExecutor newCallbackExecutor(CallbackThreadPoolOptions options) {
        if (options == null) {
            return null;
        }
        AbstractQueue workQueue = options.blockingQueueLength() > 0 ? new LinkedBlockingQueue(options.blockingQueueLength()) : new SynchronousQueue();
        return ThreadPools.builder().corePoolSize(options.coreSize()).maximumPoolSize(options.maxSize()).keepAliveTime(options.keepAliveSeconds()).workQueue(workQueue).threadFactory((ThreadFactory)new ThreadFactoryImpl("HttpClient-Callback", true)).rejectPolicy((r, executor) -> LoggerUtils.logger().error("HttpClient-Callback-Thread-Pool has been full, a task was rejected")).build();
    }

    private static EventLoopGroup sharedIoThreads() {
        if (ChannelPoolFactory.PREFER_NATIVE && Epoll.isAvailable()) {
            return new EpollEventLoopGroup(IOTHREADS, (ThreadFactory)new ThreadFactoryImpl("NettyHttpClient-I/O", true));
        }
        return new NioEventLoopGroup(IOTHREADS, (ThreadFactory)new ThreadFactoryImpl("NettyHttpClient-I/O", true));
    }

    private void addAcceptEncodingIfAbsent(HttpRequest request) {
        if (request.headers().contains("accept-encoding")) {
            return;
        }
        if (this.builder.isUseDecompress()) {
            Decompression decompression;
            request.headers().set("accept-encoding", (Object)((decompression = this.builder.decompression()) == null ? Decompression.GZIP_DEFLATE.format() : decompression.format()));
        }
    }

    protected SslEngineFactory loadSslEngineFactory(SslOptions sslOptions) {
        SslContext sslContext;
        List sslEngineFactories = SpiLoader.getAll(SslEngineFactory.class);
        if (!sslEngineFactories.isEmpty()) {
            return (SslEngineFactory)sslEngineFactories.get(0);
        }
        SslProvider provider = OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
        SslContextBuilder builder = SslContextBuilder.forClient();
        builder.sslProvider(provider);
        if (sslOptions != null && sslOptions.ciphers().length > 0) {
            builder.ciphers(Arrays.asList(sslOptions.ciphers()));
        }
        if (sslOptions != null && sslOptions.sessionTimeout() > 0L) {
            builder.sessionTimeout(sslOptions.sessionTimeout());
        }
        if (sslOptions != null && sslOptions.sessionCacheSize() > 0L) {
            builder.sessionCacheSize(sslOptions.sessionCacheSize());
        }
        if (sslOptions != null && sslOptions.useInsecureTrustManager()) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (sslOptions != null && sslOptions.trustCertificates() != null) {
            builder.trustManager(sslOptions.trustCertificates());
        }
        if (HttpVersion.HTTP_2 == this.builder.version()) {
            builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
        try {
            sslContext = builder.build();
        }
        catch (SSLException ex) {
            throw ExceptionUtils.asRuntime((Throwable)ex);
        }
        return new SslEngineFactoryImpl(sslContext);
    }

    private static class IoThreadMetricImpl
    implements IoThreadMetric {
        private final SingleThreadEventLoop eventExecutor;

        private IoThreadMetricImpl(SingleThreadEventLoop eventExecutor) {
            this.eventExecutor = eventExecutor;
        }

        @Override
        public int pendingTasks() {
            return this.eventExecutor.pendingTasks();
        }

        @Override
        public int maxPendingTasks() {
            return (Integer)BeanUtils.getFieldValue((Object)this.eventExecutor, (String)"maxPendingTasks");
        }

        @Override
        public int ioRatio() {
            return (Integer)BeanUtils.getFieldValue((Object)this.eventExecutor, (String)"ioRatio");
        }

        @Override
        public String name() {
            return this.eventExecutor.threadProperties().name();
        }

        @Override
        public int priority() {
            return this.eventExecutor.threadProperties().priority();
        }

        @Override
        public String state() {
            return this.eventExecutor.threadProperties().state().name();
        }

        public String toString() {
            return new StringJoiner(", ", IoThreadMetricImpl.class.getSimpleName() + "[", "]").add("name='" + this.name() + "'").add("pendingTasks=" + this.pendingTasks()).add("maxPendingTasks=" + this.maxPendingTasks()).add("ioRatio=" + this.ioRatio()).add("priority=" + this.priority()).add("state='" + this.state() + "'").toString();
        }
    }

    static class IoThreadGroupMetricImpl
    implements IoThreadGroupMetric {
        private final MultithreadEventLoopGroup multiGroup;
        private final String id;

        IoThreadGroupMetricImpl(MultithreadEventLoopGroup multiGroup, String id) {
            this.multiGroup = multiGroup;
            this.id = id;
        }

        @Override
        public boolean isShutdown() {
            return this.multiGroup.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.multiGroup.isTerminated();
        }

        @Override
        public List<IoThreadMetric> childExecutors() {
            LinkedList<IoThreadMetric> metrics = new LinkedList<IoThreadMetric>();
            for (EventExecutor executor : this.multiGroup) {
                if (!(executor instanceof SingleThreadEventLoop)) continue;
                IoThreadMetricImpl subMetrics = new IoThreadMetricImpl((SingleThreadEventLoop)executor);
                metrics.add(subMetrics);
            }
            return metrics;
        }

        @Override
        public String groupId() {
            return this.id;
        }

        public String toString() {
            return new StringJoiner(", ", IoThreadGroupMetricImpl.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("shutdown=" + this.isShutdown()).add("terminated=" + this.isTerminated()).add("childExecutors=" + this.childExecutors()).toString();
        }
    }

    static class CallbackExecutorMetricImpl
    implements CallbackExecutorMetric {
        private final ThreadPoolExecutor callbackExecutor;
        private final String id;

        CallbackExecutorMetricImpl(ThreadPoolExecutor callbackExecutor, String id) {
            this.callbackExecutor = callbackExecutor;
            this.id = id;
        }

        @Override
        public int coreSize() {
            return this.callbackExecutor.getCorePoolSize();
        }

        @Override
        public int maxSize() {
            return this.callbackExecutor.getMaximumPoolSize();
        }

        @Override
        public long keepAliveSeconds() {
            return this.callbackExecutor.getKeepAliveTime(TimeUnit.SECONDS);
        }

        @Override
        public int activeCount() {
            return this.callbackExecutor.getActiveCount();
        }

        @Override
        public int poolSize() {
            return this.callbackExecutor.getPoolSize();
        }

        @Override
        public int largestPoolSize() {
            return this.callbackExecutor.getLargestPoolSize();
        }

        @Override
        public long taskCount() {
            return this.callbackExecutor.getTaskCount();
        }

        @Override
        public int queueSize() {
            return this.callbackExecutor.getQueue().size();
        }

        @Override
        public long completedTaskCount() {
            return this.callbackExecutor.getCompletedTaskCount();
        }

        @Override
        public String executorId() {
            return this.id;
        }

        public String toString() {
            return new StringJoiner(", ", CallbackExecutorMetricImpl.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("coreSize=" + this.coreSize()).add("maxSize=" + this.maxSize()).add("keepAliveSeconds=" + this.keepAliveSeconds()).add("activeCount=" + this.activeCount()).add("poolSize=" + this.poolSize()).add("largestPoolSize=" + this.largestPoolSize()).add("taskCount=" + this.taskCount()).add("queueSize=" + this.queueSize()).add("completedTaskCount=" + this.completedTaskCount()).toString();
        }
    }
}

