/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpVersion;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.HttpResponse;

public class NettyResponse
implements HttpResponse {
    private final HttpHeaders trailers = new Http1HeadersImpl();
    private final boolean aggregated;
    private volatile HttpMessage message;
    private volatile Buffer body = Buffer.defaultAlloc().buffer(0);

    public NettyResponse(boolean aggregated) {
        this.aggregated = aggregated;
    }

    @Override
    public HttpVersion version() {
        return this.message.version();
    }

    @Override
    public int status() {
        return this.message.status();
    }

    @Override
    public Buffer body() {
        return this.body == null ? Buffer.defaultAlloc().empty() : this.body;
    }

    @Override
    public HttpHeaders headers() {
        return this.message.headers();
    }

    @Override
    public HttpHeaders trailers() {
        return this.trailers;
    }

    @Override
    public boolean aggregated() {
        return this.aggregated;
    }

    void message(HttpMessage message) {
        this.message = message;
    }

    void body(Buffer body) {
        this.body = body;
    }
}

