/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.config.ChannelPoolOptions;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.CachedChannelPools;
import io.esastack.httpclient.core.netty.ChannelPoolFactory;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.HttpTransceiverImpl;
import io.esastack.httpclient.core.netty.NettyExecContext;
import io.esastack.httpclient.core.netty.RequestWriter;
import io.esastack.httpclient.core.netty.SegmentWriter;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;

class NettyTransceiver
extends HttpTransceiverImpl {
    NettyTransceiver(EventLoopGroup ioThreads, CachedChannelPools channelPools, HttpClientBuilder builder, ChannelPoolOptions channelPoolOptions, ChannelPoolFactory channelPoolFactory) {
        super(ioThreads, channelPools, builder, channelPoolOptions, channelPoolFactory);
    }

    @Override
    public CompletableFuture<HttpResponse> handle(HttpRequest request, ExecContext execCtx) {
        if (request.isSegmented() && execCtx instanceof NettyExecContext) {
            ((NettyExecContext)execCtx).segmentWriter(new CompletableFuture<SegmentWriter>());
        }
        return super.handle(request, execCtx);
    }

    @Override
    protected void onAcquireChannelPoolFailure(HttpRequest request, ExecContext execCtx, SocketAddress address, Throwable cause) {
        super.onAcquireChannelPoolFailure(request, execCtx, address, cause);
        this.tryCompleteSegmentExceptionally(request, execCtx, cause);
    }

    @Override
    protected void onAcquireChannelFailure(HttpRequest request, SocketAddress address, ExecContext execCtx, CompletableFuture<HttpResponse> response, Throwable ex) {
        super.onAcquireChannelFailure(request, address, execCtx, response, ex);
        this.tryCompleteSegmentExceptionally(request, execCtx, ex);
    }

    @Override
    protected void completeExceptionally(HttpRequest request, ExecContext execCtx, CompletableFuture<HttpResponse> response, Throwable cause) {
        super.completeExceptionally(request, execCtx, response, cause);
        this.tryCompleteSegmentExceptionally(request, execCtx, cause);
    }

    @Override
    protected void afterWriting(int requestId, HttpRequest request, ExecContext execCtx, RequestWriter writer, ChannelFuture headFuture, ChannelFuture endFuture, TimeoutHandle handle, HandleRegistry registry, CompletableFuture<HttpResponse> response) {
        super.afterWriting(requestId, request, execCtx, writer, headFuture, endFuture, handle, registry, response);
        if (request.isSegmented() && execCtx instanceof NettyExecContext) {
            ((NettyExecContext)execCtx).segmentWriter().ifPresent(writer0 -> writer0.complete((SegmentWriter)writer));
        }
    }

    @Override
    protected void tryToCleanAndEndExceptionally(HttpRequest request, ExecContext execCtx, int requestId, HandleRegistry registry, TimeoutHandle handle, CompletableFuture<HttpResponse> response, Throwable cause) {
        super.tryToCleanAndEndExceptionally(request, execCtx, requestId, registry, handle, response, cause);
        this.tryCompleteSegmentExceptionally(request, execCtx, cause);
    }

    private void tryCompleteSegmentExceptionally(HttpRequest request, ExecContext execCtx, Throwable cause) {
        if (request.isSegmented() && execCtx instanceof NettyExecContext) {
            ((NettyExecContext)execCtx).segmentWriter().ifPresent(writer -> writer.completeExceptionally(cause));
        }
    }
}

