/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.exception.ClosedConnectionException;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.RequestWriterImpl;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.BufferUtils;
import io.esastack.httpclient.core.util.HttpHeadersUtils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;

class PlainWriter
extends RequestWriterImpl {
    private static final PlainWriter INSTANCE = new PlainWriter();

    @Override
    ChannelFuture writeAndFlush1(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, HttpVersion version, boolean uriEncodeEnabled) {
        PlainWriter.addContentLengthIfAbsent(request, v -> request.buffer() == null ? 0L : (long)request.buffer().readableBytes());
        if (request.buffer() == null || request.buffer().readableBytes() <= 0) {
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(version, HttpMethod.valueOf((String)request.method().name()), request.uri().relative(uriEncodeEnabled), Unpooled.EMPTY_BUFFER, (HttpHeaders)((Http1HeadersImpl)request.headers()), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("Send Request:\n" + req);
            }
            return channel.writeAndFlush((Object)req, headFuture);
        }
        String uri = request.uri().relative(uriEncodeEnabled);
        channel.write((Object)new DefaultHttpRequest(version, HttpMethod.valueOf((String)request.method().name()), uri, (HttpHeaders)((Http1HeadersImpl)request.headers())), headFuture);
        ChannelPromise endPromise = channel.newPromise();
        if (PlainWriter.writeContentNow(execCtx, request)) {
            Utils.runInChannel(channel, () -> PlainWriter.doWriteContent1(channel, request.buffer(), endPromise));
        } else {
            channel.flush();
            execCtx.set100ContinueCallback(() -> Utils.runInChannel(channel, () -> PlainWriter.doWriteContent1(channel, request.buffer(), endPromise)));
        }
        return endPromise;
    }

    private static void doWriteContent1(Channel channel, Buffer content, ChannelPromise endPromise) {
        if (!channel.isActive()) {
            endPromise.tryFailure((Throwable)new ClosedConnectionException("Connection: " + channel + " inactive"));
            return;
        }
        ByteBuf buf = BufferUtils.toByteBuf(content).retainedSlice();
        channel.writeAndFlush((Object)new DefaultLastHttpContent(buf), endPromise);
    }

    @Override
    ChannelFuture writeAndFlush2(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, Http2ConnectionHandler handler, int streamId, boolean uriEncodeEnabled) {
        PlainWriter.addContentLengthIfAbsent(request, v -> request.buffer() == null ? 0L : (long)request.buffer().readableBytes());
        ChannelFuture future = this.checkAndWriteH2Headers(channel, handler, HttpHeadersUtils.toHttp2Headers(request, (Http1HeadersImpl)request.headers(), uriEncodeEnabled), streamId, false, headFuture);
        if (future.isDone() && !future.isSuccess()) {
            return future;
        }
        ByteBuf data = request.buffer() == null ? Unpooled.EMPTY_BUFFER : BufferUtils.toByteBuf(request.buffer()).retainedSlice();
        ChannelPromise endPromise = channel.newPromise();
        if (PlainWriter.writeContentNow(execCtx, request)) {
            PlainWriter.doWriteContent2(channel, data, handler, streamId, endPromise);
        } else {
            channel.flush();
            execCtx.set100ContinueCallback(() -> PlainWriter.doWriteContent2(channel, data, handler, streamId, endPromise));
        }
        return endPromise;
    }

    private static void doWriteContent2(Channel channel, ByteBuf data, Http2ConnectionHandler handler, int streamId, ChannelPromise endPromise) {
        handler.writeData(streamId, data, true, endPromise);
        channel.flush();
    }

    private PlainWriter() {
    }

    static PlainWriter singleton() {
        return INSTANCE;
    }
}

