/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.net.SocketTimeoutException;

final class ReadTimeoutTask
implements TimerTask {
    private final int requestId;
    private final String uri;
    private final Channel channel;
    private final HandleRegistry registry;
    private final long timeout;

    ReadTimeoutTask(int requestId, String uri, long timeout, Channel channel, HandleRegistry registry) {
        this.requestId = requestId;
        this.uri = uri;
        this.timeout = timeout;
        this.channel = channel;
        this.registry = registry;
    }

    public void run(Timeout timeout) {
        ResponseHandle handle = this.registry.remove(this.requestId);
        if (handle != null) {
            this.channel.eventLoop().execute(() -> handle.onError(new SocketTimeoutException("Request: " + this.uri + " exceeds read timeout: " + this.timeout + "ms")));
            this.channel.close();
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("Request: " + this.uri + " exceeds read timeout " + this.timeout + "ms, begin to close connection: " + this.channel);
            }
        }
    }

    void cancel() {
        ResponseHandle handle = this.registry.remove(this.requestId);
        if (handle != null) {
            handle.onError(new IllegalStateException("Request: " + this.uri + " haven't finished while connection: " + this.channel + "has closed"));
        }
    }
}

