/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.Scheme;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.RequestWriter;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

abstract class RequestWriterImpl
implements RequestWriter {
    private static final Predicate<HttpRequest> CONTENT_LENGTH_ABSENT = request -> {
        HttpHeaders headers0 = request.headers();
        return !headers0.contains("content-length") && !headers0.contains("transfer-encoding");
    };
    private static final Predicate<HttpRequest> CONTENT_TYPE_ABSENT = request -> !request.headers().contains("content-type");
    private static final Predicate<HttpRequest> HOST_ABSENT = request -> !request.headers().contains("host");

    RequestWriterImpl() {
    }

    @Override
    public ChannelFuture writeAndFlush(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, boolean useUriEncode, HttpVersion version, boolean http2) throws IOException {
        RequestWriterImpl.addHostIfAbsent(request, () -> RequestWriterImpl.computeHost(request.uri().netURI()));
        if (http2) {
            Http2ConnectionHandler handler = RequestWriterImpl.getH2Handler(channel);
            int streamId = request.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            return this.writeAndFlush2(request, channel, execCtx, headFuture, handler, streamId, useUriEncode);
        }
        return this.writeAndFlush1(request, channel, execCtx, headFuture, version, useUriEncode);
    }

    final ChannelFuture checkAndWriteH2Headers(Channel channel, Http2ConnectionHandler handler, Http2Headers headers, int streamId, boolean endOfStream, ChannelPromise headFuture) {
        if (streamId < 0) {
            headFuture.setFailure((Throwable)new StreamIdExhaustedException("No more streams can be created on connection: " + channel + "(local), and current connection will close gracefully"));
            handler.writeGoAwayOnExhaustion(channel.newPromise());
            return headFuture;
        }
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("Send Request:\n" + headers);
        }
        return handler.writeHeaders(streamId, headers, endOfStream, headFuture);
    }

    abstract ChannelFuture writeAndFlush2(HttpRequest var1, Channel var2, ExecContext var3, ChannelPromise var4, Http2ConnectionHandler var5, int var6, boolean var7) throws IOException;

    abstract ChannelFuture writeAndFlush1(HttpRequest var1, Channel var2, ExecContext var3, ChannelPromise var4, HttpVersion var5, boolean var6) throws IOException;

    static void addContentLengthIfAbsent(HttpRequest request, ToLongFunction<HttpRequest> contentLength) {
        if (!CONTENT_LENGTH_ABSENT.test(request)) {
            return;
        }
        long contentLengthVal = contentLength.applyAsLong(request);
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("content-length is absent, try to set default value: {}, uri: {}", (Object)contentLengthVal, (Object)request.uri().toString());
        }
        request.headers().set("content-length", (Object)contentLengthVal);
    }

    static void addContentTypeIfAbsent(HttpRequest request, Supplier<CharSequence> contentType) {
        if (!CONTENT_TYPE_ABSENT.test(request)) {
            return;
        }
        CharSequence contentTypeVal = contentType.get();
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("content-type is absent, try to set default value: {}, uri: {}", (Object)contentTypeVal, (Object)request.uri().toString());
        }
        request.headers().set("content-type", (Object)contentTypeVal);
    }

    static boolean writeContentNow(ExecContext context, HttpRequest request) {
        return !request.headers().contains("expect", "100-continue", true);
    }

    static String computeHost(URI uri) {
        int port = uri.getPort();
        if (port <= 0) {
            return uri.getHost();
        }
        if (uri.getScheme().equalsIgnoreCase(Scheme.HTTP.name0()) && uri.getPort() == Scheme.HTTP.port()) {
            return uri.getHost();
        }
        if (uri.getScheme().equalsIgnoreCase(Scheme.HTTPS.name0()) && uri.getPort() == Scheme.HTTPS.port()) {
            return uri.getHost();
        }
        return uri.getHost() + ":" + uri.getPort();
    }

    private static void addHostIfAbsent(HttpRequest request, Supplier<String> host) {
        if (!HOST_ABSENT.test(request)) {
            return;
        }
        String hostVal = host.get();
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("host is absent, try to set default value: {}, uri: {}", (Object)hostVal, (Object)request.uri().toString());
        }
        request.headers().set("host", (Object)host.get());
    }

    private static Http2ConnectionHandler getH2Handler(Channel channel) throws ConnectException {
        Http2ConnectionHandler handler = (Http2ConnectionHandler)channel.pipeline().get(Http2ConnectionHandler.class);
        if (handler != null) {
            return handler;
        }
        throw Utils.CONNECT_INACTIVE;
    }

    private static class StreamIdExhaustedException
    extends RuntimeException {
        private static final long serialVersionUID = 6638917105569802492L;

        private StreamIdExhaustedException(String msg) {
            super(msg);
        }
    }
}

