/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.io.IOUtils;
import io.esastack.httpclient.core.netty.DelegatingResolver;
import io.esastack.httpclient.core.resolver.HostResolver;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;

class ResolverGroupImpl
extends AddressResolverGroup<InetSocketAddress> {
    private static final ConcurrentHashMap<HostResolver, ResolverGroupImpl> RESOLVER_GROUPS = new ConcurrentHashMap(1);
    private final HostResolver delegate;

    private ResolverGroupImpl(HostResolver delegate) {
        Checks.checkNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    protected AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) {
        return new DelegatingResolver(executor, this.delegate).asAddressResolver();
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.delegate);
        super.close();
    }

    static ResolverGroupImpl mappingTo(HostResolver hostResolver) {
        return RESOLVER_GROUPS.computeIfAbsent(hostResolver, resolver -> new ResolverGroupImpl(hostResolver));
    }
}

