/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.HandleImpl;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.esastack.httpclient.core.util.LoggerUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

class ResponseHandle {
    final HandleImpl handle;
    final HttpRequest request;
    private final AtomicBoolean ended = new AtomicBoolean();
    private final ExecContext execCtx;
    private final TimeoutHandle tHandle;
    private final CompletableFuture<HttpResponse> response;
    long remaining = -1L;

    ResponseHandle(HandleImpl handle, HttpRequest request, ExecContext execCtx, TimeoutHandle tHandle, CompletableFuture<HttpResponse> response) {
        Checks.checkNotNull((Object)handle, (String)"handle");
        Checks.checkNotNull((Object)request, (String)"request");
        Checks.checkNotNull((Object)execCtx, (String)"execCtx");
        Checks.checkNotNull(response, (String)"response");
        Checks.checkNotNull((Object)tHandle, (String)"tHandle");
        this.handle = handle;
        this.tHandle = tHandle;
        this.request = request;
        this.execCtx = execCtx;
        this.response = response;
    }

    public void onMessage(HttpMessage message) {
        if (this.ended.get()) {
            return;
        }
        try {
            this.handle.underlying.message(message);
            this.tHandle.onMessageReceived(this.request, this.execCtx.ctx(), message);
            if (this.handle.start != null) {
                this.handle.start.accept(null);
            }
        }
        catch (Throwable ex) {
            this.onError(ex);
        }
    }

    public void onData(Buffer content) {
        if (this.ended.get()) {
            return;
        }
        try {
            if (this.handle.data != null) {
                this.handle.data.accept(content);
            }
        }
        catch (Throwable ex) {
            this.onError(ex);
        }
    }

    public void onEnd() {
        if (this.ended.get()) {
            return;
        }
        try {
            if (this.ended.compareAndSet(false, true)) {
                if (this.handle.end != null) {
                    this.handle.end.accept(null);
                }
                this.response.complete(this.handle.underlying);
                this.tHandle.onCompleted(this.request, this.execCtx.ctx(), this.handle.underlying);
            }
        }
        catch (Throwable ex) {
            this.onError0(ex);
        }
    }

    public void onError(Throwable cause) {
        if (this.ended.compareAndSet(false, true)) {
            this.onError0(cause);
        }
    }

    public void onTrailers(HttpHeaders trailers) {
        if (this.ended.get()) {
            return;
        }
        try {
            if (this.handle.trailers != null) {
                this.handle.trailers.accept(trailers);
            }
        }
        catch (Throwable ex) {
            this.onError(ex);
        }
    }

    public ExecContext ctx() {
        return this.execCtx;
    }

    private void onError0(Throwable cause) {
        this.response.completeExceptionally(cause);
        try {
            if (this.handle.error != null) {
                this.handle.error.accept(cause);
            }
            this.tHandle.onError(this.request, this.execCtx.ctx(), cause);
        }
        catch (Throwable ex) {
            LoggerUtils.logger().error("Unexpected exception occurred on handle#onError0", cause);
        }
    }
}

