/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequestBaseImpl;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.ListenerProxy;
import io.esastack.httpclient.core.SegmentRequest;
import io.esastack.httpclient.core.exec.RequestExecutor;
import io.esastack.httpclient.core.netty.NettyExecContext;
import io.esastack.httpclient.core.netty.SegmentWriter;
import io.esastack.httpclient.core.netty.Utils;
import io.esastack.httpclient.core.util.BufferUtils;
import io.esastack.httpclient.core.util.Futures;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.MathUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SegmentRequestImpl
extends HttpRequestBaseImpl
implements SegmentRequest {
    private static final IllegalStateException REQUEST_HAS_ENDED = new IllegalStateException("Request has ended");
    private static final IllegalStateException CONNECTION_IS_NULL = new IllegalStateException("Connection is null");
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final RequestExecutor executor;
    private volatile CompletableFuture<HttpResponse> response;
    private volatile CompletableFuture<SegmentWriter> segmentWriter;
    private CompletableFuture<SegmentWriter> orderedWriterOpsChain;
    private boolean started;
    private boolean ended;

    SegmentRequestImpl(HttpClientBuilder builder, RequestExecutor executor, HttpMethod method, String uri) {
        super(builder, method, uri);
        Checks.checkNotNull((Object)executor, (String)"executor");
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> write(byte[] data, int offset, int length) {
        if (data == null) {
            data = EMPTY_BYTES;
        }
        SegmentRequestImpl.checkIndex(data, offset, length);
        this.checkAndStart();
        return this.checkAndWrite(data, offset, length);
    }

    @Override
    public CompletableFuture<Void> write(Buffer data) {
        this.checkAndStart();
        return this.checkAndWrite(data, -1, -1);
    }

    @Override
    public CompletableFuture<HttpResponse> end(byte[] data, int offset, int length, Consumer<Throwable> handle) {
        if (data == null) {
            data = EMPTY_BYTES;
        }
        SegmentRequestImpl.checkIndex(data, offset, length);
        this.checkAndWrite(data, offset, length);
        this.safelyDoEnd(null).whenComplete((BiConsumer)this.handleOnEnd(handle));
        return this.response;
    }

    @Override
    public CompletableFuture<HttpResponse> end(Consumer<Throwable> handle) {
        this.checkAndStart();
        this.safelyDoEnd(null).whenComplete((BiConsumer)this.handleOnEnd(handle));
        return this.response;
    }

    @Override
    public CompletableFuture<HttpResponse> end(HttpHeaders trailers, Consumer<Throwable> handle) {
        this.checkAndStart();
        this.safelyDoEnd(trailers).whenComplete((BiConsumer)this.handleOnEnd(handle));
        return this.response;
    }

    @Override
    public CompletableFuture<HttpResponse> end(Buffer data, Consumer<Throwable> handle) {
        this.checkAndStart();
        this.checkAndWrite(data, -1, -1);
        this.safelyDoEnd(null).whenComplete((BiConsumer)this.handleOnEnd(handle));
        return this.response;
    }

    @Override
    public boolean isWritable() {
        if (this.segmentWriter == null) {
            return false;
        }
        if (!this.segmentWriter.isDone()) {
            return false;
        }
        Channel channel = ((SegmentWriter)this.segmentWriter.getNow(null)).channel();
        if (channel != null) {
            return channel.isWritable();
        }
        return false;
    }

    private static void checkIndex(byte[] bytes, int off, int len) {
        if (MathUtil.isOutOfBounds((int)off, (int)len, (int)bytes.length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    private <T> CompletableFuture<Void> checkAndWrite(T data, int offset, int length) {
        try {
            if (this.segmentWriter.isDone() && this.segmentWriter.isCompletedExceptionally()) {
                return Futures.completed(new IOException("Failed to acquire connection", Futures.getCause(this.segmentWriter)));
            }
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            BiConsumer<SegmentWriter, Throwable> consumer = (wr, th) -> this.doWrite((SegmentWriter)wr, data, offset, length).whenComplete((v, th0) -> {
                if (th0 != null) {
                    result.completeExceptionally((Throwable)th0);
                } else {
                    result.complete(null);
                }
            });
            this.appendToOrderedWriterOpsChain(consumer);
            return result;
        }
        catch (Throwable th2) {
            return Futures.completed(new IOException("Unexpected error occurred when writing content", th2));
        }
    }

    private <T> CompletableFuture<Void> doWrite(SegmentWriter writer, T data, int offset, int length) {
        Channel channel;
        if (writer == null || (channel = writer.channel()) == null) {
            return Futures.completed(CONNECTION_IS_NULL);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (channel.eventLoop().inEventLoop()) {
            if (this.ended) {
                future.completeExceptionally(REQUEST_HAS_ENDED);
            } else {
                SegmentRequestImpl.joinToComplete(future, writer.write(data, offset, length));
            }
        } else {
            channel.eventLoop().execute(() -> {
                if (this.ended) {
                    future.completeExceptionally(REQUEST_HAS_ENDED);
                } else {
                    SegmentRequestImpl.joinToComplete(future, writer.write(data, offset, length));
                }
            });
        }
        if (data instanceof Buffer) {
            return future.whenComplete((rsp, th) -> Utils.tryRelease((ReferenceCounted)BufferUtils.toByteBuf((Buffer)data)));
        }
        return future;
    }

    private CompletableFuture<Void> safelyDoEnd(HttpHeaders headers) {
        try {
            if (this.segmentWriter.isDone() && this.segmentWriter.isCompletedExceptionally()) {
                return Futures.completed(new IOException("Failed to acquire connection", Futures.getCause(this.segmentWriter)));
            }
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            BiConsumer<SegmentWriter, Throwable> consumer = (wr, th) -> this.doEnd((SegmentWriter)wr, headers).whenComplete((v, th0) -> {
                if (th0 != null) {
                    result.completeExceptionally((Throwable)th0);
                } else {
                    result.complete(null);
                }
            });
            this.appendToOrderedWriterOpsChain(consumer);
            return result;
        }
        catch (Throwable th2) {
            return Futures.completed(new IOException("Unexpected error occurred when ending request", th2));
        }
    }

    private CompletableFuture<Void> doEnd(SegmentWriter writer, HttpHeaders headers) {
        if (writer == null || writer.channel() == null) {
            return Futures.completed(CONNECTION_IS_NULL);
        }
        Channel channel = writer.channel();
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Runnable endTask = () -> {
            if (this.ended) {
                promise.completeExceptionally(REQUEST_HAS_ENDED);
            }
            this.ended = true;
            ChannelFuture endPromise = headers == null ? writer.end() : writer.end(headers);
            SegmentRequestImpl.joinToComplete(promise, endPromise);
        };
        Utils.runInChannel(channel, endTask);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndStart() {
        if (this.segmentWriter != null) {
            return;
        }
        SegmentRequestImpl segmentRequestImpl = this;
        synchronized (segmentRequestImpl) {
            if (this.segmentWriter != null) {
                return;
            }
            this.started = true;
            NettyExecContext execCtx = new NettyExecContext(this.ctx, ListenerProxy.DEFAULT, this.handle, this.handler);
            this.response = this.executor.execute(this, execCtx);
            this.segmentWriter = execCtx.segmentWriter().orElse(null);
        }
    }

    private BiConsumer<Void, Throwable> handleOnEnd(Consumer<Throwable> handle) {
        return (v, th) -> {
            SegmentWriter writer;
            if (handle != null) {
                handle.accept((Throwable)th);
            }
            if ((writer = (SegmentWriter)this.segmentWriter.getNow(null)) != null) {
                writer.close((Throwable)th);
            }
            if (th != null) {
                this.response.completeExceptionally((Throwable)th);
            }
        };
    }

    private synchronized void appendToOrderedWriterOpsChain(BiConsumer<SegmentWriter, Throwable> consumer) {
        this.orderedWriterOpsChain = this.orderedWriterOpsChain == null ? this.segmentWriter.whenComplete((BiConsumer)consumer) : this.orderedWriterOpsChain.whenComplete((BiConsumer)consumer);
    }

    private static void joinToComplete(CompletableFuture<Void> promise, ChannelFuture future) {
        if (future.isDone()) {
            if (future.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(future.cause());
            }
        } else {
            future.addListener(f -> {
                if (f.isSuccess()) {
                    promise.complete(null);
                } else {
                    promise.completeExceptionally(f.cause());
                }
            });
        }
    }

    private void checkStarted() {
        if (this.started) {
            throw new IllegalStateException("Request's execute() has been called  and the modification isn't allowed");
        }
    }

    @Override
    public SegmentRequest copy() {
        SegmentRequestImpl copied = new SegmentRequestImpl(this.builder, this.executor, this.method(), this.uri().toString());
        SegmentRequestImpl.copyTo(this, copied);
        return copied;
    }

    @Override
    public SegmentRequest enableUriEncode() {
        this.checkStarted();
        super.enableUriEncode();
        return this;
    }

    @Override
    public SegmentRequest disableExpectContinue() {
        this.checkStarted();
        super.disableExpectContinue();
        return this;
    }

    @Override
    public SegmentRequest maxRedirects(int maxRedirects) {
        this.checkStarted();
        super.maxRedirects(maxRedirects);
        return this;
    }

    @Override
    public SegmentRequest maxRetries(int maxRetries) {
        this.checkStarted();
        super.maxRetries(maxRetries);
        return this;
    }

    @Override
    public SegmentRequest readTimeout(long readTimeout) {
        this.checkStarted();
        super.readTimeout(readTimeout);
        return this;
    }

    @Override
    public SegmentRequest addHeaders(Map<? extends CharSequence, ? extends CharSequence> headers) {
        super.addHeaders((Map)headers);
        return this;
    }

    @Override
    public SegmentRequest addHeader(CharSequence name, CharSequence value) {
        super.addHeader(name, value);
        return this;
    }

    @Override
    public SegmentRequest setHeader(CharSequence name, CharSequence value) {
        super.setHeader(name, value);
        return this;
    }

    @Override
    public SegmentRequest removeHeader(CharSequence name) {
        super.removeHeader(name);
        return this;
    }

    @Override
    public SegmentRequest addParams(Map<String, String> params) {
        this.checkStarted();
        super.addParams((Map)params);
        return this;
    }

    @Override
    public SegmentRequest addParam(String name, String value) {
        this.checkStarted();
        super.addParam(name, value);
        return this;
    }

    @Override
    public SegmentRequest handle(Consumer<Handle> handle) {
        this.checkStarted();
        super.handle(handle);
        return this;
    }

    @Override
    public SegmentRequest handler(Handler handler) {
        this.checkStarted();
        super.handler(handler);
        return this;
    }
}

