/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.StringUtils;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.netty.Http2ConnectionHandler;
import io.esastack.httpclient.core.netty.RequestWriterImpl;
import io.esastack.httpclient.core.util.BufferUtils;
import io.esastack.httpclient.core.util.HttpHeadersUtils;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;

class SegmentWriter
extends RequestWriterImpl {
    private volatile ChannelPromise endPromise;
    private volatile Channel channel;
    private volatile boolean http2;
    private volatile Http2ConnectionHandler h2Handler;
    private volatile int streamId;

    SegmentWriter() {
    }

    @Override
    public ChannelFuture writeAndFlush(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, boolean useUriEncode, HttpVersion version, boolean http2) throws IOException {
        this.endPromise = channel.newPromise();
        this.channel = channel;
        return super.writeAndFlush(request, channel, execCtx, headFuture, useUriEncode, version, http2);
    }

    @Override
    ChannelFuture writeAndFlush2(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, Http2ConnectionHandler handler, int streamId, boolean uriEncodeEnabled) {
        ChannelFuture future = this.checkAndWriteH2Headers(channel, handler, HttpHeadersUtils.toHttp2Headers(request, (Http1HeadersImpl)request.headers(), uriEncodeEnabled), streamId, false, headFuture);
        if (future.isDone() && !future.isSuccess()) {
            return future;
        }
        this.h2Handler = handler;
        this.http2 = true;
        this.streamId = streamId;
        return this.endPromise;
    }

    @Override
    ChannelFuture writeAndFlush1(HttpRequest request, Channel channel, ExecContext execCtx, ChannelPromise headFuture, HttpVersion version, boolean uriEncodeEnabled) {
        DefaultHttpRequest request0 = new DefaultHttpRequest(version, HttpMethod.valueOf((String)request.method().name()), request.uri().relative(uriEncodeEnabled), (HttpHeaders)((Http1HeadersImpl)request.headers()));
        if (StringUtils.isEmpty((String)request0.headers().get("content-length")) && StringUtils.isEmpty((String)request0.headers().get("transfer-encoding"))) {
            if (LoggerUtils.logger().isDebugEnabled()) {
                LoggerUtils.logger().debug("content-length and transfer-encoding are both absent, try to set default transfer-encoding: chunked, uri: {}", (Object)request.uri().toString());
            }
            HttpUtil.setTransferEncodingChunked((HttpMessage)request0, (boolean)true);
        }
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("Send Request:\n" + request0);
        }
        channel.write((Object)request0, headFuture);
        this.http2 = false;
        return this.endPromise;
    }

    <T> ChannelFuture write(T data, int offset, int length) {
        ChannelFuture future;
        ByteBuf buf;
        assert (this.channel.eventLoop().inEventLoop());
        if (data instanceof Buffer) {
            buf = BufferUtils.toByteBuf((Buffer)data).retain();
        } else if (data instanceof byte[]) {
            buf = this.channel.alloc().buffer(length);
            buf.writeBytes((byte[])data, offset, length);
        } else {
            return this.channel.newFailedFuture((Throwable)new IllegalArgumentException("Unexpected writable data format: " + data.getClass() + ", expected(byte[], Buffer)"));
        }
        if (this.http2) {
            future = this.h2Handler.writeData(this.streamId, buf, false, this.channel.newPromise());
            this.channel.flush();
        } else {
            future = this.channel.writeAndFlush((Object)new DefaultHttpContent(buf));
        }
        return future;
    }

    ChannelFuture end() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.http2) {
            this.h2Handler.writeData(this.streamId, Unpooled.EMPTY_BUFFER, true, this.endPromise);
            this.channel.flush();
        } else {
            this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.endPromise);
        }
        return this.endPromise;
    }

    ChannelFuture end(io.esastack.commons.net.http.HttpHeaders trailers) {
        assert (this.channel.eventLoop().inEventLoop());
        try {
            if (this.http2) {
                DefaultHttp2Headers trailers0 = new DefaultHttp2Headers(HttpHeadersUtils.VALIDATE);
                HttpConversionUtil.toHttp2Headers((HttpHeaders)HttpHeadersUtils.toHttpHeaders(trailers), (Http2Headers)trailers0);
                this.h2Handler.writeHeaders(this.streamId, (Http2Headers)trailers0, true, this.endPromise);
                this.channel.flush();
            } else {
                DefaultLastHttpContent content = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, HttpHeadersUtils.VALIDATE);
                content.trailingHeaders().add(HttpHeadersUtils.toHttpHeaders(trailers));
                this.channel.writeAndFlush((Object)content, this.endPromise);
            }
        }
        catch (Throwable ex) {
            Exception ex0;
            if (this.endPromise.isDone()) {
                ex0 = new IllegalStateException("Failed to end request, maybe has already ended");
            } else {
                ex0 = new IOException("Failed to end request, and the connection will be released automatically");
                try {
                    this.endPromise.setFailure((Throwable)ex0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.channel.newFailedFuture((Throwable)ex0);
        }
        return this.endPromise;
    }

    void close(Throwable cause) {
        try {
            this.endPromise.setFailure(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    Channel channel() {
        if (this.channel != null) {
            return this.channel;
        }
        throw new IllegalStateException("Connection is null");
    }
}

