/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import io.esastack.httpclient.core.config.SslOptions;
import io.esastack.httpclient.core.spi.SslEngineFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import javax.net.ssl.SSLEngine;

class SslEngineFactoryImpl
implements SslEngineFactory {
    private final SslContext sslContext;

    SslEngineFactoryImpl(SslContext sslContext) {
        Checks.checkNotNull((Object)sslContext, (String)"sslContext");
        this.sslContext = sslContext;
    }

    @Override
    public SSLEngine create(SslOptions options, String peerHost, int peerPort) {
        return this.sslContext.newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
    }

    @Override
    public void onDestroy() {
        ReferenceCountUtil.safeRelease((Object)this.sslContext);
    }
}

