/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.Checks;
import esa.commons.concurrent.NettyInternalThread;
import io.esastack.httpclient.core.util.LoggerUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class ThreadFactoryImpl
implements ThreadFactory {
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;

    ThreadFactoryImpl(String prefix, boolean daemon) {
        Checks.checkNotNull((Object)prefix, (String)"prefix");
        this.prefix = prefix + "-" + POOL_ID.getAndIncrement() + "#";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.prefix + this.nextId.getAndIncrement();
        InternalThread t = new InternalThread(r, this.prefix, name);
        try {
            if (((Thread)((Object)t)).isDaemon() != this.daemon) {
                ((Thread)((Object)t)).setDaemon(this.daemon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Thread)((Object)t)).setUncaughtExceptionHandler((thread, error) -> LoggerUtils.logger().error("Caught unexpected exception in thread: " + thread.getName(), error));
        return t;
    }

    private static class InternalThread
    extends NettyInternalThread {
        private InternalThread(Runnable target, String prefix, String name) {
            super(target, name);
            LoggerUtils.logger().info("Creating " + prefix + " thread: {}", (Object)name);
        }
    }
}

