/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.ContextKeys;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.exec.ExecContext;
import io.esastack.httpclient.core.filter.FilterContext;
import io.esastack.httpclient.core.filter.ResponseFilter;
import io.esastack.httpclient.core.netty.DefaultHandle;
import io.esastack.httpclient.core.netty.FilteringHandle;
import io.esastack.httpclient.core.netty.HandleImpl;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.TimeoutHandle;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import java.util.concurrent.CompletableFuture;

abstract class TransceiverHandle {
    TransceiverHandle() {
    }

    abstract TimeoutHandle buildTimeoutHandle(Channel var1, ChannelPool var2, Listener var3, HttpVersion var4);

    int addRspHandle(HttpRequest request, ExecContext execCtx, Channel channel, ResponseFilter[] filters, HandleRegistry registry, TimeoutHandle tHandle, CompletableFuture<HttpResponse> response) {
        ResponseHandle nHandle = this.buildNettyHandle(request, tHandle, execCtx, channel, filters, response);
        return this.addRspHandle0(request, execCtx.ctx(), channel, nHandle, registry);
    }

    abstract int addRspHandle0(HttpRequest var1, Context var2, Channel var3, ResponseHandle var4, HandleRegistry var5);

    private ResponseHandle buildNettyHandle(HttpRequest request, TimeoutHandle tHandle, ExecContext execCtx, Channel channel, ResponseFilter[] filters, CompletableFuture<HttpResponse> response) {
        HandleImpl handle = execCtx.handleImpl(request);
        if (handle == null) {
            handle = new DefaultHandle(channel.alloc());
        }
        if (filters == null || filters.length == 0) {
            return new ResponseHandle(handle, request, execCtx, tHandle, response);
        }
        return new FilteringHandle(handle, request, execCtx, tHandle, response, filters, (FilterContext)execCtx.ctx().attrs().attr(ContextKeys.FILTER_CONTEXT_KEY).getAndRemove());
    }
}

