/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.netty;

import esa.commons.StringUtils;
import esa.commons.logging.Logger;
import io.esastack.httpclient.core.Scheme;
import io.esastack.httpclient.core.exception.ClosedConnectionException;
import io.esastack.httpclient.core.netty.HandleRegistry;
import io.esastack.httpclient.core.netty.ResponseHandle;
import io.esastack.httpclient.core.netty.ThreadFactoryImpl;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

final class Utils {
    static final ScheduledExecutorService CLOSE_CONNECTION_POOL_SCHEDULER = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("ESAHttpClient-CloseConnectionPool-Scheduler", true), (r, executor) -> LoggerUtils.logger().error("ESAHttpClient-CloseConnectionPool-Scheduler-Pool has full, a task has been rejected"));
    static final ConnectException CONNECT_INACTIVE = new ConnectException("Connection inactive");
    static final ConnectException WRITE_BUF_IS_FULL = new ConnectException("Connection write buffer is full");
    private static final Logger logger = LoggerUtils.logger();

    Utils() {
    }

    static void handleH1ChannelEx(HandleRegistry registry, Channel channel, int reusableRequestId, Throwable cause, boolean enableLog) {
        ResponseHandle handle = registry.remove(reusableRequestId);
        if (handle == null) {
            return;
        }
        boolean hasLogged = false;
        if (cause instanceof ClosedConnectionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("ClosedConnectionException occurred in connection: {}, maybe server has closed connection", (Object)channel);
            }
            hasLogged = true;
        } else if (cause instanceof IOException) {
            if (logger.isDebugEnabled()) {
                logger.debug("IOException occurred in connection: {}", (Object)channel, (Object)cause);
            } else {
                logger.warn("Exception occurred in connection: {}, maybe server has closed connection", (Object)channel);
            }
            hasLogged = true;
        }
        Utils.handleException(handle, cause, !hasLogged && enableLog);
    }

    static void handleH2ChannelEx(HandleRegistry registry, Channel channel, Throwable cause) {
        if (cause instanceof ClosedConnectionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("ClosedConnectionException occurred in connection: {}", (Object)channel, (Object)cause);
            }
        } else if (cause instanceof IOException) {
            if (logger.isDebugEnabled()) {
                logger.debug("IOException occurred in connection: {}", (Object)channel, (Object)cause);
            } else {
                logger.warn("Exception occurred in connection: {}, maybe server has closed connection", (Object)channel);
            }
        }
        channel.closeFuture().addListener(future -> registry.handleAndClearAll(h -> {
            try {
                Utils.handleException(h, cause, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }));
    }

    static boolean handleIdleEvt(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent idleEvt;
        if (evt instanceof IdleStateEvent && IdleState.ALL_IDLE == (idleEvt = (IdleStateEvent)evt).state()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Close idle connection: {}", (Object)ctx.channel());
            }
            ctx.channel().close();
            return true;
        }
        return false;
    }

    static void runInChannel(Channel channel, Runnable runnable) {
        if (channel.eventLoop().inEventLoop()) {
            runnable.run();
        } else {
            channel.eventLoop().execute(runnable);
        }
    }

    static Http2Headers standardHeaders(Http2Headers headers) {
        for (Http2Headers.PseudoHeaderName name : Http2Headers.PseudoHeaderName.values()) {
            headers.remove((Object)name.value());
        }
        return headers;
    }

    static boolean getValue(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    static void handleException(ResponseHandle handle, Throwable cause, boolean enableLog) {
        if (handle == null) {
            return;
        }
        if (enableLog) {
            logger.warn("Unexpected exception occurred, and the request has to end in error.", cause);
        }
        handle.onError(cause);
    }

    static void tryRelease(ReferenceCounted msg) {
        if (msg == null) {
            return;
        }
        if (msg.refCnt() > 0) {
            ReferenceCountUtil.safeRelease((Object)msg);
        }
    }

    static Scheme toScheme(URI uri) {
        String scheme = uri.getScheme();
        if (StringUtils.isEmpty((String)scheme)) {
            return Scheme.HTTP;
        }
        if (Scheme.HTTPS.name0().equalsIgnoreCase(scheme)) {
            return Scheme.HTTPS;
        }
        return Scheme.HTTP;
    }
}

