/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.resolver;

import esa.commons.Checks;
import esa.commons.loadbalance.LoadBalancer;
import esa.commons.loadbalance.RandomLoadBalancer;
import io.esastack.httpclient.core.resolver.HostResolver;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class BalancedHostResolver
implements HostResolver {
    private static final LoadBalancer<InetAddress> RANDOM_BALANCER = new RandomLoadBalancer();
    private final LoadBalancer<InetAddress> loadBalancer;

    public BalancedHostResolver() {
        this(RANDOM_BALANCER);
    }

    public BalancedHostResolver(LoadBalancer<InetAddress> loadBalancer) {
        Checks.checkNotNull(loadBalancer, (String)"loadBalancer");
        this.loadBalancer = loadBalancer;
    }

    public final CompletableFuture<InetAddress> resolve(String inetHost) {
        return this.resolveAll(inetHost).thenApply(addresses -> {
            if (addresses != null && !addresses.isEmpty()) {
                return (InetAddress)this.loadBalancer.select(addresses);
            }
            return null;
        });
    }

    protected abstract CompletableFuture<List<InetAddress>> resolveAll(String var1);
}

