/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.util;

import esa.commons.Checks;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public final class Futures {
    private Futures() {
    }

    public static <T> CompletableFuture<T> completed(Throwable t) {
        Checks.checkArg((t != null ? 1 : 0) != 0, (String)"throwable must not be null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<T> completed() {
        return CompletableFuture.completedFuture(null);
    }

    public static <T> CompletableFuture<T> completed(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static Throwable unwrapped(Throwable t) {
        if (t instanceof CompletionException || t instanceof ExecutionException) {
            return t.getCause();
        }
        return t;
    }

    public static Throwable getCause(CompletableFuture<?> future) {
        if (!future.isCompletedExceptionally()) {
            return null;
        }
        try {
            future.getNow(null);
        }
        catch (Throwable ex) {
            return Futures.unwrapped(ex);
        }
        return null;
    }
}

