/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.util;

import esa.commons.StringUtils;
import io.esastack.commons.net.http.EmptyHttpHeaders;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.HttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

public final class HttpHeadersUtils {
    public static final String TTFB = "$ttfb";
    private static final String VALIDATE_KEY = "io.esastack.httpclient.validateHttpHeaders";
    public static final boolean VALIDATE = SystemPropertyUtil.getBoolean((String)"io.esastack.httpclient.validateHttpHeaders", (boolean)true);
    private static final AsciiString EMPTY_REQUEST_PATH = AsciiString.cached((String)"/");

    private HttpHeadersUtils() {
    }

    public static HttpHeaders copyFrom(HttpHeaders headers0) {
        if (headers0 == null || headers0.isEmpty()) {
            return new Http1HeadersImpl();
        }
        if (headers0 instanceof Http1HeadersImpl) {
            return ((Http1HeadersImpl)headers0).copy();
        }
        return new Http1HeadersImpl().add(headers0);
    }

    public static io.netty.handler.codec.http.HttpHeaders toHttpHeaders(HttpHeaders headers) {
        if (headers == null || headers instanceof EmptyHttpHeaders) {
            return io.netty.handler.codec.http.EmptyHttpHeaders.INSTANCE;
        }
        if (headers instanceof Http1HeadersImpl) {
            return (Http1HeadersImpl)headers;
        }
        DefaultHttpHeaders headers0 = new DefaultHttpHeaders(VALIDATE);
        Iterator iterator = headers.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry item = (Map.Entry)iterator.next();
            headers0.add((CharSequence)item.getKey(), item.getValue());
        }
        return headers0;
    }

    public static Http2Headers toHttp2Headers(HttpRequest request, Http1HeadersImpl headers, boolean uriEncodeEnabled) {
        DefaultHttp2Headers out = new DefaultHttp2Headers(VALIDATE, headers.size());
        String path = request.uri().relative(uriEncodeEnabled);
        out.path((CharSequence)(StringUtils.isEmpty((String)path) ? EMPTY_REQUEST_PATH : new AsciiString((CharSequence)path)));
        out.method((CharSequence)new AsciiString((CharSequence)request.method().name()));
        URI uri = request.uri().netURI();
        HttpHeadersUtils.setHttp2Scheme((io.netty.handler.codec.http.HttpHeaders)headers, request.scheme(), (Http2Headers)out);
        if (!HttpUtil.isOriginForm((URI)uri) && !HttpUtil.isAsteriskForm((URI)uri)) {
            String host = headers.getAsString((CharSequence)HttpHeaderNames.HOST);
            HttpHeadersUtils.setHttp2Authority(host == null || host.isEmpty() ? uri.getAuthority() : host, (Http2Headers)out);
        }
        HttpConversionUtil.toHttp2Headers((io.netty.handler.codec.http.HttpHeaders)headers, (Http2Headers)out);
        return out;
    }

    private static void setHttp2Scheme(io.netty.handler.codec.http.HttpHeaders in, String scheme, Http2Headers out) {
        if (StringUtils.isNotEmpty((String)scheme)) {
            out.scheme((CharSequence)AsciiString.cached((String)scheme));
            return;
        }
        scheme = in.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
        if (!StringUtils.isNotEmpty((String)scheme)) {
            throw new IllegalArgumentException(":scheme must be specified");
        }
        out.scheme((CharSequence)AsciiString.cached((String)scheme));
    }

    private static void setHttp2Authority(String authority, Http2Headers out) {
        if (authority != null) {
            if (authority.isEmpty()) {
                out.authority((CharSequence)AsciiString.EMPTY_STRING);
            } else {
                int start = authority.indexOf(64) + 1;
                int length = authority.length() - start;
                if (length == 0) {
                    throw new IllegalArgumentException("authority: " + authority);
                }
                out.authority((CharSequence)new AsciiString((CharSequence)authority, start, length));
            }
        }
    }
}

