/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.util;

import esa.commons.collection.MultiValueMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class MultiValueMapUtils {
    private MultiValueMapUtils() {
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMap(MultiValueMap<K, V> underlying) {
        return underlying == null ? null : new UnmodifiableMultiValueMap(underlying);
    }

    private static class UnmodifiableMultiValueMap<K, V>
    implements MultiValueMap<K, V> {
        private static final UnsupportedOperationException UNSUPPORTED = new UnsupportedOperationException();
        private final MultiValueMap<K, V> underlying;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, List<V>>> entrySet;
        private transient Collection<List<V>> values;

        private UnmodifiableMultiValueMap(MultiValueMap<K, V> underlying) {
            this.underlying = underlying;
        }

        public void add(K key, V value) {
            throw UNSUPPORTED;
        }

        public void addAll(K key, Iterable<? extends V> values) {
            throw UNSUPPORTED;
        }

        public void addFirst(K key, V value) {
            throw UNSUPPORTED;
        }

        public V getFirst(K key) {
            return (V)this.underlying.getFirst(key);
        }

        public void putSingle(K key, V value) {
            throw UNSUPPORTED;
        }

        public Map<K, V> toSingleValueMap() {
            return this.underlying.toSingleValueMap();
        }

        public int size() {
            return this.underlying.size();
        }

        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.underlying.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.underlying.containsValue(value);
        }

        public List<V> get(Object key) {
            List values = (List)this.underlying.get(key);
            return values == null ? null : Collections.unmodifiableList(values);
        }

        public List<V> put(K key, List<V> value) {
            throw UNSUPPORTED;
        }

        public List<V> remove(Object key) {
            throw UNSUPPORTED;
        }

        public void putAll(Map<? extends K, ? extends List<V>> m) {
            throw UNSUPPORTED;
        }

        public void clear() {
            throw UNSUPPORTED;
        }

        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.underlying.keySet());
            }
            return this.keySet;
        }

        public Collection<List<V>> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.underlying.values());
            }
            return this.values;
        }

        public Set<Map.Entry<K, List<V>>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.underlying.entrySet());
            }
            return this.entrySet;
        }

        public List<V> getOrDefault(Object key, List<V> defaultValue) {
            List values = (List)this.underlying.getOrDefault(key, defaultValue);
            return values == null ? null : Collections.unmodifiableList(values);
        }

        public void forEach(BiConsumer<? super K, ? super List<V>> action) {
            this.underlying.forEach(action);
        }

        public void replaceAll(BiFunction<? super K, ? super List<V>, ? extends List<V>> function) {
            throw UNSUPPORTED;
        }

        public List<V> putIfAbsent(K key, List<V> value) {
            throw UNSUPPORTED;
        }

        public boolean remove(Object key, Object value) {
            throw UNSUPPORTED;
        }

        public boolean replace(K key, List<V> oldValue, List<V> newValue) {
            throw UNSUPPORTED;
        }

        public List<V> replace(K key, List<V> value) {
            throw UNSUPPORTED;
        }

        public List<V> computeIfAbsent(K key, Function<? super K, ? extends List<V>> mappingFunction) {
            throw UNSUPPORTED;
        }

        public List<V> computeIfPresent(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
            throw UNSUPPORTED;
        }

        public List<V> compute(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
            throw UNSUPPORTED;
        }

        public List<V> merge(K key, List<V> value, BiFunction<? super List<V>, ? super List<V>, ? extends List<V>> remappingFunction) {
            throw UNSUPPORTED;
        }
    }
}

