/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.GroupMessage;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LeakData;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011a\u0003T3bWJ+\u0007o\u001c:uKJ$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u0007\u0011\taa\u001e:ji\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019H/\u0019;t\u0015\t9\u0001\"\u0001\u0003d_J,'BA\u0005\u000b\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aC\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001\u001dA\u0019q\u0002\u0005\n\u000e\u0003\tI!!\u0005\u0002\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u0002\u0010'%\u0011AC\u0001\u0002\t\u0019\u0016\f7\u000eR1uC\"Aa\u0003\u0001B\u0001B\u0003%q#A\u0003dY>\u001c7\u000e\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!Q\u000f^5m\u0015\ta\u0002\"A\u0004d_6lwN\\:\n\u0005yI\"!B\"m_\u000e\\\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\u0011S%D\u0001$\u0015\t!c!\u0001\u0004d_:4\u0017nZ\u0005\u0003M\r\u0012AcR1uY&twmQ8oM&<WO]1uS>t\u0007\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"a\u0004\u0001\t\u000bY9\u0003\u0019A\f\t\u000b\u0001:\u0003\u0019A\u0011\t\u000f9\u0002!\u0019!C\u0005_\u0005qa\r\\;tQRKW.\u001a:OC6,W#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u00027b]\u001eT\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\t11\u000b\u001e:j]\u001eDa!\u000f\u0001!\u0002\u0013\u0001\u0014a\u00044mkNDG+[7fe:\u000bW.\u001a\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\r=t\u0017J\\5u)\t\u0011R\bC\u0003?u\u0001\u0007q(\u0001\u0003j]&$\bCA\bA\u0013\t\t%A\u0001\u0003J]&$\b\"B\"\u0001\t\u0003\"\u0015aB8o\r2,8\u000f\u001b\u000b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013A!\u00168ji\")AJ\u0011a\u0001%\u0005!A-\u0019;b\u0011\u0015q\u0005\u0001\"\u0003P\u00035yg.V:fe6+7o]1hKR\u0019Q\tU+\t\u000bEk\u0005\u0019\u0001*\u0002\tU\u001cXM\u001d\t\u0003\u001fMK!\u0001\u0016\u0002\u0003\u0017U\u001bXM]'fgN\fw-\u001a\u0005\u0006\u00196\u0003\rA\u0005\u0005\u0006/\u0002!I\u0001W\u0001\u000f_:<%o\\;q\u001b\u0016\u001c8/Y4f)\r)\u0015L\u0018\u0005\u00065Z\u0003\raW\u0001\u0006OJ|W\u000f\u001d\t\u0003\u001fqK!!\u0018\u0002\u0003\u0019\u001d\u0013x.\u001e9NKN\u001c\u0018mZ3\t\u000b13\u0006\u0019\u0001\n\t\u000b\u0001\u0004A\u0011B1\u0002#=t'+Z:q_:\u001cX-T3tg\u0006<W\rF\u0002FE\u001eDQaY0A\u0002\u0011\f\u0001B]3ta>t7/\u001a\t\u0003\u001f\u0015L!A\u001a\u0002\u0003\u001fI+7\u000f]8og\u0016lUm]:bO\u0016DQ\u0001T0A\u0002IAQ!\u001b\u0001\u0005B)\f\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u0007\u0015[\u0007\u000fC\u0003mQ\u0002\u0007Q.A\u0004nKN\u001c\u0018mZ3\u0011\u0005=q\u0017BA8\u0003\u0005Aau.\u00193Fm\u0016tG/T3tg\u0006<W\rC\u0003MQ\u0002\u0007!\u0003C\u0003s\u0001\u0011\u00053/A\u0004p]\u000e\u0013\u0018m\u001d5\u0015\t\u0015#\u0018\u0011\u0001\u0005\u0006kF\u0004\rA^\u0001\u0006G\u0006,8/\u001a\t\u0003ozt!\u0001\u001f?\u0011\u0005e<U\"\u0001>\u000b\u0005md\u0011A\u0002\u001fs_>$h(\u0003\u0002~\u000f\u00061\u0001K]3eK\u001aL!aN@\u000b\u0005u<\u0005\"\u0002'r\u0001\u0004\u0011\u0002bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\u0007_:\u001cFo\u001c9\u0015\u0007\u0015\u000bI\u0001\u0003\u0004M\u0003\u0007\u0001\rA\u0005")
public class LeakReporterDataWriter
extends DataWriter<LeakData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    @Override
    public LeakData onInit(Init init) {
        FiniteDuration noActivityTimeout = this.configuration.data().leak().noActivityTimeout();
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, noActivityTimeout, true);
        return new LeakData(noActivityTimeout, this.clock.nowMillis(), (Map<Object, DataWriterMessage>)Map$.MODULE$.empty());
    }

    @Override
    public void onFlush(LeakData data) {
        block0: {
            long timeSinceLastTouch = (this.clock.nowMillis() - data.lastTouch()) / 1000L;
            if (timeSinceLastTouch <= data.noActivityTimeout().toSeconds() || !data.events().nonEmpty()) break block0;
            System.err.println(new StringBuilder(96).append("Gatling had no activity during last ").append(data.noActivityTimeout()).append(". It could be a virtual user leak, here's their last events:").toString());
            data.events().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                System.err.println(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void onUserMessage(UserMessage user, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)user.session().userId())), (Object)user));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            data.events().$minus$eq((Object)BoxesRunTime.boxToLong((long)user.session().userId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onGroupMessage(GroupMessage group, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)group.userId())), (Object)group));
    }

    private void onResponseMessage(ResponseMessage response, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)response.userId())), (Object)response));
    }

    @Override
    public void onMessage(LoadEventMessage message, LeakData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof GroupMessage) {
            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
            this.onGroupMessage(groupMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)loadEventMessage);
        }
    }

    @Override
    public void onCrash(String cause, LeakData data) {
    }

    @Override
    public void onStop(LeakData data) {
        this.cancelTimer(this.flushTimerName());
    }

    public LeakReporterDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

