/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.http.HeaderNames$;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.check.checksum.ChecksumCheck;
import io.gatling.http.client.Request;
import io.gatling.http.response.ByteArrayResponseBody$;
import io.gatling.http.response.ByteArrayResponseBodyUsage$;
import io.gatling.http.response.CharArrayResponseBody$;
import io.gatling.http.response.CharArrayResponseBodyUsage$;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.InputStreamResponseBodyUsage$;
import io.gatling.http.response.NoResponseBody$;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBodyUsageStrategy;
import io.gatling.http.response.ResponseBuilder$;
import io.gatling.http.response.StringResponseBody$;
import io.gatling.http.response.StringResponseBodyUsage$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmt!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fgB|gn]3Ck&dG-\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fgB|gn]3\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011\"\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0004*fgB|gn]3Ck&dG-\u001a:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u00055\u0019FO]5di2{wmZ5oO\")\u0011%\u0004C\u0001E\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\bI5\u0011\r\u0011\"\u0003&\u00039I5\u000fR3ck\u001e,e.\u00192mK\u0012,\u0012A\n\t\u0003#\u001dJ!\u0001\u000b\n\u0003\u000f\t{w\u000e\\3b]\"1!&\u0004Q\u0001\n\u0019\nq\"S:EK\n,x-\u00128bE2,G\r\t\u0005\u0006Y5!\t!L\u0001\u001a]\u0016<(+Z:q_:\u001cXMQ;jY\u0012,'OR1di>\u0014\u0018\u0010F\u0003/k!SE\u000b\u0005\u00020e9\u0011A\u0002M\u0005\u0003c\t\tq\u0001]1dW\u0006<W-\u0003\u00024i\t1\"+Z:q_:\u001cXMQ;jY\u0012,'OR1di>\u0014\u0018P\u0003\u00022\u0005!)ag\u000ba\u0001o\u000511\r[3dWN\u00042\u0001O C\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003cII!\u0001Q!\u0003\t1K7\u000f\u001e\u0006\u0003cI\u0001\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0003\u0002\u000b\rDWmY6\n\u0005\u001d#%!\u0003%uiB\u001c\u0005.Z2l\u0011\u0015I5\u00061\u0001'\u0003IIgNZ3s\u0011RlGNU3t_V\u00148-Z:\t\u000b-[\u0003\u0019\u0001'\u0002\u000b\rdwnY6\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B;uS2T!!\u0015\u0004\u0002\u000f\r|W.\\8og&\u00111K\u0014\u0002\u0006\u00072|7m\u001b\u0005\u0006+.\u0002\rAV\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016AB2p]\u001aLwM\u0003\u0002\\\r\u0005!1m\u001c:f\u0013\ti\u0006L\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u0004\u0005\u001d\t\u0001ql\u0005\u0002_!!A\u0011M\u0018B\u0001B\u0003%!-A\u0004sKF,Xm\u001d;\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015$\u0011AB2mS\u0016tG/\u0003\u0002hI\n9!+Z9vKN$\b\u0002C5_\u0005\u0003\u0005\u000b\u0011\u00026\u0002\u001d\rDWmY6tk6\u001c\u0005.Z2lgB\u0019\u0001hP6\u0011\u00051|W\"A7\u000b\u00059$\u0015\u0001C2iK\u000e\\7/^7\n\u0005Al'!D\"iK\u000e\\7/^7DQ\u0016\u001c7\u000e\u0003\u0005s=\n\u0005\t\u0015!\u0003t\u0003M\u0011w\u000eZ=Vg\u0006<Wm\u0015;sCR,w-[3t!\rADO^\u0005\u0003k\u0006\u00131aU3r!\taq/\u0003\u0002y\u0005\tI\"+Z:q_:\u001cXMQ8esV\u001b\u0018mZ3TiJ\fG/Z4z\u0011!QhL!A!\u0002\u00131\u0013AD:u_J,'i\u001c3z!\u0006\u0014Ho\u001d\u0005\t\u0013z\u0013\t\u0011)A\u0005M!AQP\u0018B\u0001B\u0003%a0\u0001\beK\u001a\fW\u000f\u001c;DQ\u0006\u00148/\u001a;\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u001d\u0019\u0007.\u0019:tKRTA!a\u0002\u0002\n\u0005\u0019a.[8\u000b\u0005\u0005-\u0011\u0001\u00026bm\u0006LA!a\u0004\u0002\u0002\t91\t[1sg\u0016$\b\u0002C&_\u0005\u0003\u0005\u000b\u0011\u0002'\t\r\u0005rF\u0011AA\u000b)A\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)\u0003\u0005\u0002\r=\"1\u0011-a\u0005A\u0002\tDa![A\n\u0001\u0004Q\u0007B\u0002:\u0002\u0014\u0001\u00071\u000f\u0003\u0004{\u0003'\u0001\rA\n\u0005\u0007\u0013\u0006M\u0001\u0019\u0001\u0014\t\ru\f\u0019\u00021\u0001\u007f\u0011\u0019Y\u00151\u0003a\u0001\u0019\"A\u0011\u0011\u00060C\u0002\u0013%Q%\u0001\td_6\u0004X\u000f^3DQ\u0016\u001c7n];ng\"9\u0011Q\u00060!\u0002\u00131\u0013!E2p[B,H/Z\"iK\u000e\\7/^7tA!Q\u0011\u0011\u00070A\u0002\u0003\u0007I\u0011A\u0013\u0002\u001dM$xN]3Ii6dwJ]\"tg\"Y\u0011Q\u00070A\u0002\u0003\u0007I\u0011AA\u001c\u0003I\u0019Ho\u001c:f\u0011RlGn\u0014:DgN|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004#\u0005m\u0012bAA\u001f%\t!QK\\5u\u0011%\t\t%a\r\u0002\u0002\u0003\u0007a%A\u0002yIEB!\"!\u0012_\u0001\u0004\u0005\t\u0015)\u0003'\u0003=\u0019Ho\u001c:f\u0011RlGn\u0014:DgN\u0004\u0003bCA%=\u0002\u0007\t\u0019!C\u0001\u0003\u0017\nab\u001d;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002NA\u0019\u0011#a\u0014\n\u0007\u0005E#C\u0001\u0003M_:<\u0007bCA+=\u0002\u0007\t\u0019!C\u0001\u0003/\n!c\u001d;beR$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011\u0011HA-\u0011)\t\t%a\u0015\u0002\u0002\u0003\u0007\u0011Q\n\u0005\f\u0003;r\u0006\u0019!A!B\u0013\ti%A\bti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!\u0011-\t\tG\u0018a\u0001\u0002\u0004%\t!a\u0013\u0002\u0019\u0015tG\rV5nKN$\u0018-\u001c9\t\u0017\u0005\u0015d\f1AA\u0002\u0013\u0005\u0011qM\u0001\u0011K:$G+[7fgR\fW\u000e]0%KF$B!!\u000f\u0002j!Q\u0011\u0011IA2\u0003\u0003\u0005\r!!\u0014\t\u0017\u00055d\f1A\u0001B\u0003&\u0011QJ\u0001\u000eK:$G+[7fgR\fW\u000e\u001d\u0011\t\u0015\u0005Ed\f1AA\u0002\u0013%Q%A\u0004jg\"#H\u000f\u001d\u001a\t\u0017\u0005Ud\f1AA\u0002\u0013%\u0011qO\u0001\fSNDE\u000f\u001e93?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005e\u0004\"CA!\u0003g\n\t\u00111\u0001'\u0011)\tiH\u0018a\u0001\u0002\u0003\u0006KAJ\u0001\tSNDE\u000f\u001e93A!I\u0011\u0011\u00110A\u0002\u0013%\u00111Q\u0001\u0007gR\fG/^:\u0016\u0005\u0005\u0015\u0005#B\t\u0002\b\u0006-\u0015bAAE%\t1q\n\u001d;j_:\u0004B!!$\u0002\u001e6\u0011\u0011q\u0012\u0006\u0004\u000b\u0005E%\u0002BAJ\u0003+\u000bQaY8eK\u000eTA!a&\u0002\u001a\u00069\u0001.\u00198eY\u0016\u0014(bAAN\u0011\u0005)a.\u001a;us&!\u0011qTAH\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\t\u0013\u0005\rf\f1A\u0005\n\u0005\u0015\u0016AC:uCR,8o\u0018\u0013fcR!\u0011\u0011HAT\u0011)\t\t%!)\u0002\u0002\u0003\u0007\u0011Q\u0011\u0005\t\u0003Ws\u0006\u0015)\u0003\u0002\u0006\u000691\u000f^1ukN\u0004\u0003\"CAX=\u0002\u0007I\u0011BAY\u0003I9\u0018N]3SKF,Xm\u001d;IK\u0006$WM]:\u0016\u0005\u0005M\u0006\u0003BAG\u0003kKA!a.\u0002\u0010\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0011%\tYL\u0018a\u0001\n\u0013\ti,\u0001\fxSJ,'+Z9vKN$\b*Z1eKJ\u001cx\fJ3r)\u0011\tI$a0\t\u0015\u0005\u0005\u0013\u0011XA\u0001\u0002\u0004\t\u0019\f\u0003\u0005\u0002Dz\u0003\u000b\u0015BAZ\u0003M9\u0018N]3SKF,Xm\u001d;IK\u0006$WM]:!\u0011%\t9M\u0018a\u0001\n\u0013\t\t,A\u0004iK\u0006$WM]:\t\u0013\u0005-g\f1A\u0005\n\u00055\u0017a\u00035fC\u0012,'o]0%KF$B!!\u000f\u0002P\"Q\u0011\u0011IAe\u0003\u0003\u0005\r!a-\t\u0011\u0005Mg\f)Q\u0005\u0003g\u000b\u0001\u0002[3bI\u0016\u00148\u000f\t\u0005\n\u0003/t\u0006\u0019!C\u0005\u00033\faa\u00195v].\u001cXCAAn!\u0011At(!8\u0011\t\u0005}\u0017Q]\u0007\u0003\u0003CTA!a9\u0002\u001a\u00061!-\u001e4gKJLA!a:\u0002b\n9!)\u001f;f\u0005V4\u0007\"CAv=\u0002\u0007I\u0011BAw\u0003)\u0019\u0007.\u001e8lg~#S-\u001d\u000b\u0005\u0003s\ty\u000f\u0003\u0006\u0002B\u0005%\u0018\u0011!a\u0001\u00037D\u0001\"a=_A\u0003&\u00111\\\u0001\bG\",hn[:!\u0011%\t9P\u0018b\u0001\n\u0013\tI0A\u0004eS\u001e,7\u000f^:\u0016\u0005\u0005m\b\u0003CA\u007f\u0005\u000b\u0011YA!\u0005\u000f\t\u0005}(\u0011\u0001\t\u0003uII1Aa\u0001\u0013\u0003\u0019\u0001&/\u001a3fM&!!q\u0001B\u0005\u0005\ri\u0015\r\u001d\u0006\u0004\u0005\u0007\u0011\u0002\u0003BA\u007f\u0005\u001bIAAa\u0004\u0003\n\t11\u000b\u001e:j]\u001e\u0004BAa\u0005\u0003\u001a5\u0011!Q\u0003\u0006\u0005\u0005/\tI!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011YB!\u0006\u0003\u001b5+7o]1hK\u0012Kw-Z:u\u0011!\u0011yB\u0018Q\u0001\n\u0005m\u0018\u0001\u00033jO\u0016\u001cHo\u001d\u0011\t\u000f\t\rb\f\"\u0001\u0003&\u0005!R\u000f\u001d3bi\u0016\u001cF/\u0019:u)&lWm\u001d;b[B$\"!!\u000f\t\u000f\t%b\f\"\u0001\u0003&\u0005\u0011R\u000f\u001d3bi\u0016,e\u000e\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\u0011iC\u0018C\u0001\u0005_\t!\"Y2dk6,H.\u0019;f)\u0011\tID!\r\t\u0011\u0005=&1\u0006a\u0001\u0003gCqA!\f_\t\u0003\u0011)\u0004\u0006\u0004\u0002:\t]\"\u0011\b\u0005\t\u0003\u0003\u0013\u0019\u00041\u0001\u0002\f\"A\u0011q\u0019B\u001a\u0001\u0004\t\u0019\fC\u0004\u0003>y#\tAa\u0010\u0002\u0011M,G\u000f\u0013;uaJ\"B!!\u000f\u0003B!9\u0011\u0011\u000fB\u001e\u0001\u00041\u0003b\u0002B\u0017=\u0012\u0005!Q\t\u000b\u0005\u0003s\u00119\u0005\u0003\u0005\u0003J\t\r\u0003\u0019AAo\u0003\u001d\u0011\u0017\u0010^3Ck\u001aDqA!\u0014_\t\u0013\u0011y%\u0001\bsKN|GN^3DQ\u0006\u00148/\u001a;\u0016\u0003yDqAa\u0015_\t\u0003\u0011)&A\u0007ck&dGMU3ta>t7/Z\u000b\u0003\u0005/\u00022\u0001\u0004B-\u0013\r\u0011YF\u0001\u0002\u000b\u0011R$\bOU3tk2$\bb\u0002B0=\u0012\u0005!\u0011M\u0001\rEVLG\u000e\u001a$bS2,(/\u001a\u000b\u0005\u0005G\u0012I\u0007E\u0002\r\u0005KJ1Aa\u001a\u0003\u0005-AE\u000f\u001e9GC&dWO]3\t\u0011\t-$Q\fa\u0001\u0005[\n\u0011\u0001\u001e\t\u0004q\t=\u0014b\u0001B9\u0003\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0005?rF\u0011\u0002B;)\u0011\u0011\u0019Ga\u001e\t\u0011\te$1\u000fa\u0001\u0005\u0017\tA\"\u001a:s_JlUm]:bO\u0016\u0004")
public class ResponseBuilder {
    private final Request request;
    private final Seq<ResponseBodyUsageStrategy> bodyUsageStrategies;
    private final boolean storeBodyParts;
    private final boolean inferHtmlResources;
    private final Charset defaultCharset;
    private final Clock clock;
    private final boolean computeChecksums;
    private boolean storeHtmlOrCss;
    private long startTimestamp;
    private long endTimestamp;
    private boolean isHttp2;
    private Option<HttpResponseStatus> status;
    private HttpHeaders wireRequestHeaders;
    private HttpHeaders headers;
    private List<ByteBuf> chunks;
    private final Map<String, MessageDigest> digests;

    public static Function1<Request, ResponseBuilder> newResponseBuilderFactory(List<HttpCheck> list, boolean bl, Clock clock, GatlingConfiguration gatlingConfiguration) {
        return ResponseBuilder$.MODULE$.newResponseBuilderFactory(list, bl, clock, gatlingConfiguration);
    }

    public static Logger logger() {
        return ResponseBuilder$.MODULE$.logger();
    }

    private boolean computeChecksums() {
        return this.computeChecksums;
    }

    public boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    public void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp_$eq(long x$1) {
        this.startTimestamp = x$1;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public void endTimestamp_$eq(long x$1) {
        this.endTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private Option<HttpResponseStatus> status() {
        return this.status;
    }

    private void status_$eq(Option<HttpResponseStatus> x$1) {
        this.status = x$1;
    }

    private HttpHeaders wireRequestHeaders() {
        return this.wireRequestHeaders;
    }

    private void wireRequestHeaders_$eq(HttpHeaders x$1) {
        this.wireRequestHeaders = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    private Map<String, MessageDigest> digests() {
        return this.digests;
    }

    public void updateStartTimestamp() {
        this.startTimestamp_$eq(this.clock.nowMillis());
    }

    public void updateEndTimestamp() {
        this.endTimestamp_$eq(this.clock.nowMillis());
    }

    public void accumulate(HttpHeaders wireRequestHeaders) {
        this.wireRequestHeaders_$eq(wireRequestHeaders);
    }

    public void accumulate(HttpResponseStatus status, HttpHeaders headers) {
        this.updateEndTimestamp();
        this.status_$eq((Option<HttpResponseStatus>)new Some((Object)status));
        if (this.headers() == EmptyHttpHeaders.INSTANCE) {
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.inferHtmlResources && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
        } else {
            this.headers().add(headers);
        }
    }

    public void setHttp2(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void accumulate(ByteBuf byteBuf) {
        block2: {
            this.updateEndTimestamp();
            if (!byteBuf.isReadable()) break block2;
            if (this.storeBodyParts || this.storeHtmlOrCss()) {
                ByteBuf byteBuf2 = byteBuf.retain();
                this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf2));
            }
            if (this.computeChecksums()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])byteBuf.nioBuffers())).foreach((Function1 & Serializable & scala.Serializable)nioBuffer -> {
                    ResponseBuilder.$anonfun$accumulate$1(this, nioBuffer);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Charset resolveCharset() {
        return (Charset)Option$.MODULE$.apply((Object)this.headers().get(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)contentType -> HttpHelper$.MODULE$.extractCharsetFromContentType((String)contentType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
    }

    public HttpResult buildResponse() {
        HttpFailure httpFailure;
        Option<HttpResponseStatus> option = this.status();
        if (option instanceof Some) {
            Product product;
            Some some = (Some)option;
            HttpResponseStatus s = (HttpResponseStatus)some.value();
            try {
                this.endTimestamp_$eq(package$.MODULE$.max(this.endTimestamp(), this.startTimestamp()));
                Map checksums = Maps.PimpedMap$.MODULE$.forceMapValues$extension(Maps$.MODULE$.PimpedMap(this.digests()), (Function1 & Serializable & scala.Serializable)md -> StringHelper$.MODULE$.bytes2Hex(md.digest()));
                int contentLength = BoxesRunTime.unboxToInt((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce(this.chunks()), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.readableBytes()), (Numeric)Numeric.IntIsIntegral$.MODULE$));
                Set bodyUsages = (Set)this.bodyUsageStrategies.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bodyUsage(contentLength), scala.collection.package$.MODULE$.breakOut(Set$.MODULE$.canBuildFrom()));
                Charset resolvedCharset = this.resolveCharset();
                List properlyOrderedChunks = this.chunks().reverse();
                NoResponseBody$ body = properlyOrderedChunks.isEmpty() ? NoResponseBody$.MODULE$ : (bodyUsages.contains((Object)ByteArrayResponseBodyUsage$.MODULE$) ? ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)InputStreamResponseBodyUsage$.MODULE$) ? InputStreamResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)StringResponseBodyUsage$.MODULE$) ? StringResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)CharArrayResponseBodyUsage$.MODULE$) ? CharArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (HttpHelper$.MODULE$.isTxt(this.headers()) ? StringResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset))))));
                this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.release()));
                this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
                product = new Response(this.request, this.wireRequestHeaders(), s, this.headers(), body, (Map<String, String>)checksums, contentLength, resolvedCharset, this.startTimestamp(), this.endTimestamp(), this.isHttp2());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option2.get();
                HttpFailure httpFailure2 = this.buildFailure(t);
                product = httpFailure2;
            }
            httpFailure = product;
        } else {
            httpFailure = this.buildFailure("How come we're trying to build a response with no status?!");
        }
        return httpFailure;
    }

    public HttpFailure buildFailure(Throwable t) {
        return this.buildFailure(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.request, this.wireRequestHeaders(), this.startTimestamp(), this.endTimestamp(), errorMessage);
    }

    public static final /* synthetic */ void $anonfun$accumulate$1(ResponseBuilder $this, ByteBuffer nioBuffer) {
        $this.digests().values().foreach((Function1 & Serializable & scala.Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public ResponseBuilder(Request request, List<ChecksumCheck> checksumChecks, Seq<ResponseBodyUsageStrategy> bodyUsageStrategies, boolean storeBodyParts, boolean inferHtmlResources, Charset defaultCharset, Clock clock) {
        this.request = request;
        this.bodyUsageStrategies = bodyUsageStrategies;
        this.storeBodyParts = storeBodyParts;
        this.inferHtmlResources = inferHtmlResources;
        this.defaultCharset = defaultCharset;
        this.clock = clock;
        this.computeChecksums = checksumChecks.nonEmpty();
        this.status = None$.MODULE$;
        this.wireRequestHeaders = EmptyHttpHeaders.INSTANCE;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.chunks = Nil$.MODULE$;
        this.digests = this.computeChecksums() ? (Map)checksumChecks.map((Function1 & Serializable & scala.Serializable)check -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)check.algorithm()), (Object)MessageDigest.getInstance(check.algorithm())), scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom())) : Predef$.MODULE$.Map().empty();
    }
}

