/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render.template;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.template.ExtractedUris;
import io.gatling.recorder.render.template.Format;
import io.gatling.recorder.render.template.UrlVal;
import io.gatling.recorder.render.template.package$;
import io.gatling.recorder.render.template.package$TemplateString$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ExtractedUris$ {
    public static final ExtractedUris$ MODULE$ = new ExtractedUris$();

    private String longestCommonRoot(List<String> pathsStrs) {
        List paths = pathsStrs.map((Function1 & Serializable)x$1 -> x$1.split("/"));
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])paths.reduce((Function2 & Serializable)(sa1, sa2) -> ExtractedUris$.longestCommonRootRec$1(sa1, sa2)))).mkString("/");
    }

    private Map<String, String> extractLongestPathUrls(List<Uri> urls, String longestCommonPath, String valName, Format format) {
        return urls.map((Function1 & Serializable)url -> {
            String restPath = url.getPath().substring(longestCommonPath.length());
            String tail = new StringBuilder(0).append(restPath).append(MODULE$.query((Uri)url)).toString();
            String urlTail = tail.isEmpty() ? valName : new StringBuilder(3).append(valName).append(" + ").append(package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(tail), format)).toString();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)url.toString()), (Object)urlTail);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, String> extractCommonHostUrls(List<Uri> uris, String valName, Format format) {
        return uris.map((Function1 & Serializable)uri -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)uri.toString()), (Object)new StringBuilder(11).append("\"").append(uri.getScheme()).append("://").append(MODULE$.user((Uri)uri)).append("\" + ").append(valName).append(" + ").append(package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(new StringBuilder(0).append(MODULE$.port((Uri)uri)).append(uri.getPath()).append(MODULE$.query((Uri)uri)).toString()), format)).toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean schemesPortAreSame(Seq<Uri> uris) {
        return IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(((IterableOnceOps)uris.map((Function1 & Serializable)uri -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)uri.getScheme()), (Object)BoxesRunTime.boxToInteger((int)uri.getExplicitPort())))).toSet().sizeIs(), 1);
    }

    private String query(Uri uri) {
        if (uri.getQuery() == null) {
            return "";
        }
        return new StringBuilder(1).append("?").append(uri.getQuery()).toString();
    }

    private String user(Uri uri) {
        if (uri.getUserInfo() == null) {
            return "";
        }
        return new StringBuilder(1).append(uri.getUserInfo()).append("@").toString();
    }

    private String port(Uri uri) {
        if (uri.getPort() != -1 && uri.getPort() != uri.getSchemeDefaultPort()) {
            return new StringBuilder(1).append(":").append(uri.getPort()).toString();
        }
        return "";
    }

    public ExtractedUris apply(Seq<HttpTrafficElement> scenarioElements, Format format) {
        Seq requestElements = (Seq)scenarioElements.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends HttpTrafficElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof RequestElement) {
                    RequestElement requestElement = (RequestElement)A1;
                    return (B1)requestElement;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(HttpTrafficElement x1) {
                HttpTrafficElement httpTrafficElement = x1;
                return httpTrafficElement instanceof RequestElement;
            }
        });
        Map urisGroupedByHost = ((IterableOnceOps)((IterableOps)((IterableOps)requestElements.map((Function1 & Serializable)x$2 -> x$2.uri())).$plus$plus((IterableOnce)requestElements.flatMap((Function1 & Serializable)x$3 -> x$3.nonEmbeddedResources().map((Function1 & Serializable)x$4 -> x$4.uri())))).map((Function1 & Serializable)x$1 -> Uri.create((String)x$1))).toList().groupBy((Function1 & Serializable)uri -> uri.getHost());
        int maxNbDigits = Integer.toString(urisGroupedByHost.size()).length();
        ObjectRef tmpUrls = ObjectRef.create((Object)Nil$.MODULE$);
        Map renders = (Map)((IterableOnceOps)((IterableOps)urisGroupedByHost.view().zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    List uris = (List)tuple22._2();
                    String valName = new StringBuilder(3).append("uri").append(StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(Integer.toString(index + 1)), maxNbDigits, "0")).toString();
                    if (IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(uris.sizeIs(), 1) || MODULE$.schemesPortAreSame((Seq<Uri>)uris)) {
                        List paths = uris.map((Function1 & Serializable)uri -> uri.getPath());
                        String longestCommonPath = MODULE$.longestCommonRoot((List<String>)paths);
                        UrlVal urlVal = new UrlVal(valName, new StringBuilder(0).append(((Uri)uris.head()).getBaseUrl()).append(longestCommonPath).toString());
                        tmpUrls$1.elem = ((List)tmpUrls$1.elem).$colon$colon((Object)urlVal);
                        return MODULE$.extractLongestPathUrls((List<Uri>)uris, longestCommonPath, valName, format);
                    }
                    UrlVal urlVal = new UrlVal(valName, ((Uri)uris.head()).getHost());
                    tmpUrls$1.elem = ((List)tmpUrls$1.elem).$colon$colon((Object)urlVal);
                    return MODULE$.extractCommonHostUrls((List<Uri>)uris, valName, format);
                }
            }
            throw new MatchError((Object)tuple2);
        })).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
        return new ExtractedUris((List<UrlVal>)((List)tmpUrls.elem), (Map<String, String>)renders);
    }

    private static final String[] longestCommonRootRec$1(String[] sa1, String[] sa2) {
        int p;
        int minLen = scala.math.package$.MODULE$.min(sa1.length, sa2.length);
        for (p = 0; p < minLen; ++p) {
            String string = sa1[p];
            String string2 = sa2[p];
            if (string != null ? !string.equals(string2) : string2 != null) break;
        }
        return (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])sa1), 0, p);
    }

    private ExtractedUris$() {
    }
}

