/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.ome;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class OhMyEmail {
    private static Session session;
    private static String user;
    private MimeMessage msg;
    private String text;
    private String html;
    private List<MimeBodyPart> attachments = new ArrayList<MimeBodyPart>();

    private OhMyEmail() {
    }

    public static Properties defaultConfig(Boolean debug) {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.debug", "false");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.debug", null != debug ? debug.toString() : "false");
        props.put("mail.smtp.timeout", "10000");
        props.put("mail.smtp.port", "465");
        return props;
    }

    public static Properties SMTP_ENT_QQ(boolean debug) {
        Properties props = OhMyEmail.defaultConfig(debug);
        props.put("mail.smtp.host", "smtp.exmail.qq.com");
        return props;
    }

    public static Properties SMTP_QQ(boolean debug) {
        Properties props = OhMyEmail.defaultConfig(debug);
        props.put("mail.smtp.host", "smtp.qq.com");
        return props;
    }

    public static Properties SMTP_163(Boolean debug) {
        Properties props = OhMyEmail.defaultConfig(debug);
        props.put("mail.smtp.host", "smtp.163.com");
        return props;
    }

    public static void config(Properties props, String username, String password) {
        props.setProperty("username", username);
        props.setProperty("password", password);
        OhMyEmail.config(props);
    }

    public static void config(Properties props) {
        final String username = props.getProperty("username");
        final String password = props.getProperty("password");
        user = username;
        session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
    }

    public static OhMyEmail subject(String subject) throws MessagingException {
        OhMyEmail ohMyEmail = new OhMyEmail();
        ohMyEmail.msg = new MimeMessage(session);
        ohMyEmail.msg.setSubject(subject, "UTF-8");
        return ohMyEmail;
    }

    public OhMyEmail from(String nickName) throws MessagingException {
        return this.from(nickName, user);
    }

    public OhMyEmail from(String nickName, String from) throws MessagingException {
        try {
            nickName = MimeUtility.encodeText((String)nickName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.msg.setFrom((Address)new InternetAddress(nickName + " <" + from + ">"));
        return this;
    }

    public OhMyEmail replyTo(String ... replyTo) throws MessagingException {
        String result = Arrays.asList(replyTo).toString().replaceAll("(^\\[|\\]$)", "").replace(", ", ",");
        this.msg.setReplyTo((Address[])InternetAddress.parse((String)result));
        return this;
    }

    public OhMyEmail replyTo(String replyTo) throws MessagingException {
        this.msg.setReplyTo((Address[])InternetAddress.parse((String)replyTo.replace(";", ",")));
        return this;
    }

    public OhMyEmail to(String ... to) throws Exception {
        return this.addRecipients(to, Message.RecipientType.TO);
    }

    public OhMyEmail to(String to) throws MessagingException {
        return this.addRecipient(to, Message.RecipientType.TO);
    }

    public OhMyEmail cc(String ... cc) throws MessagingException {
        return this.addRecipients(cc, Message.RecipientType.CC);
    }

    public OhMyEmail cc(String cc) throws MessagingException {
        return this.addRecipient(cc, Message.RecipientType.CC);
    }

    public OhMyEmail bcc(String ... bcc) throws MessagingException {
        return this.addRecipients(bcc, Message.RecipientType.BCC);
    }

    public OhMyEmail bcc(String bcc) throws MessagingException {
        return this.addRecipient(bcc, Message.RecipientType.BCC);
    }

    private OhMyEmail addRecipients(String[] recipients, Message.RecipientType type) throws MessagingException {
        String result = Arrays.asList(recipients).toString().replace("(^\\[|\\]$)", "").replace(", ", ",");
        this.msg.setRecipients(type, (Address[])InternetAddress.parse((String)result));
        return this;
    }

    private OhMyEmail addRecipient(String recipient, Message.RecipientType type) throws MessagingException {
        this.msg.setRecipients(type, (Address[])InternetAddress.parse((String)recipient.replace(";", ",")));
        return this;
    }

    public OhMyEmail text(String text) {
        this.text = text;
        return this;
    }

    public OhMyEmail html(String html) {
        this.html = html;
        return this;
    }

    public OhMyEmail attach(File file) throws MessagingException {
        this.attachments.add(this.createAttachment(file, null));
        return this;
    }

    public OhMyEmail attach(File file, String fileName) throws MessagingException {
        this.attachments.add(this.createAttachment(file, fileName));
        return this;
    }

    private MimeBodyPart createAttachment(File file, String fileName) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
        try {
            attachmentPart.setFileName(null == fileName ? MimeUtility.encodeText((String)fds.getName()) : MimeUtility.encodeText((String)fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachmentPart;
    }

    public void send() throws MessagingException {
        MimeMultipart cover;
        boolean hasAttachments;
        if (this.text == null && this.html == null) {
            throw new NullPointerException("At least one context has to be provided: Text or Html");
        }
        boolean usingAlternative = false;
        boolean bl = hasAttachments = this.attachments.size() > 0;
        if (this.text != null && this.html == null) {
            cover = new MimeMultipart("mixed");
            cover.addBodyPart((BodyPart)this.textPart());
        } else if (this.text == null && this.html != null) {
            cover = new MimeMultipart("mixed");
            cover.addBodyPart((BodyPart)this.htmlPart());
        } else {
            cover = new MimeMultipart("alternative");
            cover.addBodyPart((BodyPart)this.textPart());
            cover.addBodyPart((BodyPart)this.htmlPart());
            usingAlternative = true;
        }
        MimeMultipart content = cover;
        if (usingAlternative && hasAttachments) {
            content = new MimeMultipart("mixed");
            content.addBodyPart((BodyPart)this.toBodyPart(cover));
        }
        for (MimeBodyPart attachment : this.attachments) {
            content.addBodyPart((BodyPart)attachment);
        }
        this.msg.setContent((Multipart)content);
        this.msg.setSentDate(new Date());
        Transport.send((Message)this.msg);
    }

    private MimeBodyPart toBodyPart(MimeMultipart cover) throws MessagingException {
        MimeBodyPart wrap = new MimeBodyPart();
        wrap.setContent((Multipart)cover);
        return wrap;
    }

    private MimeBodyPart textPart() throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(this.text);
        return bodyPart;
    }

    private MimeBodyPart htmlPart() throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)this.html, "text/html; charset=utf-8");
        return bodyPart;
    }
}

